/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.ldap.LdapName;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.settings.Settings;

public class AdminDNs {
    protected static final Logger log = LogManager.getLogger(AdminDNs.class);
    private static final Set<LdapName> adminDn = new HashSet<LdapName>();
    private final ListMultimap<LdapName, String> allowedImpersonations = ArrayListMultimap.create();

    public AdminDNs(Settings settings) {
        String[] adminDnsA = settings.getAsArray("searchguard.authcz.admin_dn");
        for (int i = 0; i < adminDnsA.length; ++i) {
            String dn = adminDnsA[i];
            try {
                log.debug("{} is registered as an admin dn", (Object)dn);
                adminDn.add(new LdapName(dn));
                continue;
            }
            catch (InvalidNameException e) {
                log.error("Unable to parse admin dn {} {}", (Object)e, (Object)dn, (Object)e);
            }
        }
        log.debug("Loaded {} admin DN's {}", (Object)adminDn.size(), adminDn);
        Map impersonationDns = settings.getGroups("searchguard.authcz.impersonation_dn");
        for (String dnString : impersonationDns.keySet()) {
            try {
                this.allowedImpersonations.putAll((Object)new LdapName(dnString), Arrays.asList(settings.getAsArray("searchguard.authcz.impersonation_dn." + dnString)));
            }
            catch (InvalidNameException e) {
                log.error("Unable to parse allowedImpersonations dn {} {}", (Object)e, (Object)dnString, (Object)e);
            }
        }
        log.debug("Loaded {} impersonation DN's {}", (Object)this.allowedImpersonations.size(), this.allowedImpersonations);
    }

    public static boolean isAdmin(String dn) {
        if (dn == null) {
            return false;
        }
        try {
            return AdminDNs.isAdmin(new LdapName(dn));
        }
        catch (InvalidNameException e) {
            return false;
        }
    }

    public static boolean isAdmin(LdapName dn) {
        if (dn == null) {
            return false;
        }
        boolean isAdmin = adminDn.contains(dn);
        if (log.isTraceEnabled()) {
            log.trace("Is principal {} an admin cert? {}", (Object)dn.toString(), (Object)isAdmin);
        }
        return isAdmin;
    }

    public boolean isImpersonationAllowed(LdapName dn, String impersonated) {
        if (dn == null) {
            return false;
        }
        if (AdminDNs.isAdmin(dn)) {
            return true;
        }
        return this.allowedImpersonations.containsEntry((Object)dn, (Object)"*") || this.allowedImpersonations.containsEntry((Object)dn, (Object)impersonated);
    }
}

