/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.HashMap;
import java.util.Map;
import org.apache.commons.io.IOUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class IndexMappingLoader
implements ConfigurationSettings {
    private static Logger logger = Loggers.getLogger(IndexMappingLoader.class);
    private final String appMappingsTemplate;
    private final String opsMappingsTemplate;
    private final String emptyProjectMappingsTemplate;

    public IndexMappingLoader(final Settings settings) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        Map<String, String> result = AccessController.doPrivileged(new PrivilegedAction<Map<String, String>>(){

            @Override
            public Map<String, String> run() {
                HashMap<String, String> mappings = new HashMap<String, String>();
                mappings.put("app", IndexMappingLoader.this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.app"));
                mappings.put("opp", IndexMappingLoader.this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.ops"));
                mappings.put("empty", IndexMappingLoader.this.loadMapping(settings, "io.fabric8.elasticsearch.kibana.mapping.empty"));
                return mappings;
            }
        });
        this.appMappingsTemplate = result.get("app");
        this.opsMappingsTemplate = result.get("opp");
        this.emptyProjectMappingsTemplate = result.get("empty");
    }

    private String loadMapping(Settings settings, String key) {
        String mapping = settings.get(key);
        if (mapping != null && new File(mapping).exists()) {
            logger.info("Trying to load Kibana mapping for {} from plugin: {}", (Object)key, (Object)mapping);
            try {
                FileInputStream stream = new FileInputStream(mapping.toString());
                return IOUtils.toString((InputStream)stream);
            }
            catch (Exception e) {
                logger.error("Unable to load the Kibana mapping specified by {}: {}", (Object)key, (Object)e, (Object)mapping);
            }
        }
        throw new RuntimeException("Unable to load index mapping for " + key + ".  The key was not in the settings or it specified a file that does not exists.");
    }

    public String getApplicationMappingsTemplate() {
        return this.appMappingsTemplate;
    }

    public String getOperationsMappingsTemplate() {
        return this.opsMappingsTemplate;
    }

    public String getEmptyProjectMappingsTemplate() {
        return this.emptyProjectMappingsTemplate;
    }
}

