/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.auth;

import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import io.fabric8.elasticsearch.plugin.OpenshiftAPIService;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginServiceFactory;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.lang.ArrayUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public class OpenShiftTokenAuthentication
implements AuthenticationBackend,
HTTPAuthenticator {
    private static final Logger LOGGER = Loggers.getLogger(OpenShiftTokenAuthentication.class);
    private final Map<String, Settings> sars;

    public OpenShiftTokenAuthentication(Settings settings) {
        this.sars = settings.getGroups("subjectAccessReviews");
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) throws ElasticsearchSecurityException {
        if (PluginServiceFactory.isReady()) {
            OpenshiftRequestContextFactory contextFactory = PluginServiceFactory.getContextFactory();
            try {
                OpenshiftRequestContextFactory.OpenshiftRequestContext requestContext = contextFactory.create(request);
                context.putTransient("x-openshift-request-context", (Object)requestContext);
                if (requestContext == OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY) {
                    return null;
                }
                return new AuthCredentials(requestContext.getUser(), this.retrieveBackendRoles(requestContext)).markComplete();
            }
            catch (ElasticsearchSecurityException ese) {
                throw ese;
            }
            catch (Exception e) {
                LOGGER.error("Error handling request", (Throwable)e);
            }
        }
        return null;
    }

    public User authenticate(AuthCredentials credentials) throws ElasticsearchSecurityException {
        if (PluginServiceFactory.isReady() && PluginServiceFactory.getThreadContext() != null) {
            OpenshiftRequestContextFactory.OpenshiftRequestContext context = (OpenshiftRequestContextFactory.OpenshiftRequestContext)PluginServiceFactory.getThreadContext().getTransient("x-openshift-request-context");
            if (context == null || context == OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY) {
                return null;
            }
            User user = new User(context.getUser(), this.retrieveBackendRoles(context));
            this.addGeneralRoles(user, credentials, context);
            return user;
        }
        return null;
    }

    private Collection<String> retrieveBackendRoles(final OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        ArrayList<String> roles = new ArrayList<String>();
        if (PluginServiceFactory.isReady()) {
            SecurityManager sm = System.getSecurityManager();
            if (sm != null) {
                sm.checkPermission((Permission)new SpecialPermission());
            }
            final OpenshiftAPIService apiService = PluginServiceFactory.getApiService();
            for (final Map.Entry<String, Settings> sar : this.sars.entrySet()) {
                boolean allowed = AccessController.doPrivileged(new PrivilegedAction<Boolean>(){

                    @Override
                    public Boolean run() {
                        try {
                            Settings params = (Settings)sar.getValue();
                            return apiService.localSubjectAccessReview(context.getToken(), params.get("namespace"), params.get("verb"), params.get("resource"), params.get("resourceAPIGroup"), ArrayUtils.EMPTY_STRING_ARRAY);
                        }
                        catch (Exception e) {
                            LOGGER.error("Exception executing LSAR", (Throwable)e);
                            return false;
                        }
                    }
                });
                if (!allowed) continue;
                roles.add(sar.getKey());
            }
        }
        return roles;
    }

    private void addGeneralRoles(User user, AuthCredentials credentials, OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        user.addRole(BaseRolesSyncStrategy.formatUserRoleName(credentials.getUsername()));
        user.addRole(BaseRolesSyncStrategy.formatUserKibanaRoleName(credentials.getUsername()));
        if (context.isOperationsUser()) {
            user.addRole("gen_project_operations");
        }
    }

    public boolean exists(User user) {
        return user != null;
    }

    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials credentials) {
        return false;
    }

    public String getType() {
        return OpenShiftTokenAuthentication.class.getName();
    }
}

