/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.ACLDocumentManager;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.elasticsearch.plugin.rest.RestChannelInterceptor;
import io.fabric8.elasticsearch.util.RequestUtils;
import java.util.function.UnaryOperator;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class DynamicACLFilter
implements ConfigurationSettings {
    private static final Logger LOGGER = Loggers.getLogger(DynamicACLFilter.class);
    private final String kibanaVersion;
    private final String kbnVersionHeader;
    private final String cdmProjectPrefix;
    private KibanaSeed kibanaSeed;
    private final ACLDocumentManager aclManager;
    private final RequestUtils utils;
    private final ThreadContext threadContext;
    private final String defaultKibanaIndex;

    public DynamicACLFilter(PluginSettings settings, KibanaSeed seed, Client client, ThreadPool threadPool, RequestUtils utils, ACLDocumentManager aclManager) {
        this.threadContext = threadPool.getThreadContext();
        this.kibanaSeed = seed;
        this.kibanaVersion = settings.getKibanaVersion();
        this.kbnVersionHeader = settings.getKbnVersionHeader();
        this.cdmProjectPrefix = settings.getCdmProjectPrefix();
        this.defaultKibanaIndex = settings.getDefaultKibanaIndex();
        this.utils = utils;
        this.aclManager = aclManager;
    }

    public RestHandler wrap(final RestHandler original, final UnaryOperator<RestHandler> unaryOperator) {
        return new RestHandler(){
            private final RestHandler localHandler = new RestHandler(){

                public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                    if ((request = DynamicACLFilter.this.continueProcessing(request, channel)) != null) {
                        RestChannelInterceptor interceptor = new RestChannelInterceptor(channel, DynamicACLFilter.this.threadContext, DynamicACLFilter.this.defaultKibanaIndex);
                        original.handleRequest(request, (RestChannel)interceptor, client);
                    }
                }
            };

            public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                RestHandler handler = (RestHandler)unaryOperator.apply(this.localHandler);
                handler.handleRequest(request, channel, client);
            }
        };
    }

    public RestRequest continueProcessing(RestRequest request, RestChannel channel) throws Exception {
        try {
            if (this.threadContext.getTransient("x-openshift-request-context") != null) {
                OpenshiftRequestContextFactory.OpenshiftRequestContext requestContext = (OpenshiftRequestContextFactory.OpenshiftRequestContext)this.threadContext.getTransient("x-openshift-request-context");
                request = this.utils.modifyRequest(request, requestContext, channel);
                if (requestContext != OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY) {
                    this.utils.logRequest(request);
                    String kbnVersion = this.getKibanaVersion(request);
                    this.kibanaSeed.setDashboards(requestContext, kbnVersion, this.cdmProjectPrefix);
                    this.aclManager.syncAcl(requestContext);
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Error handling request", (Throwable)e);
        }
        return request;
    }

    private String getKibanaVersion(RestRequest request) {
        String kbnVersion = StringUtils.defaultIfEmpty((String)request.header(this.kbnVersionHeader), (String)"");
        if (StringUtils.isEmpty((String)kbnVersion)) {
            return this.kibanaVersion;
        }
        return kbnVersion;
    }
}

