/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.ConfigCallback;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetRequest;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.JsonSettingsLoader;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.threadpool.ThreadPool;

public class ConfigurationLoader {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final Client client;
    private final ThreadContext threadContext;
    private final String searchguardIndex;

    public ConfigurationLoader(Client client, ThreadPool threadPool, Settings settings) {
        this.client = client;
        this.threadContext = threadPool.getThreadContext();
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
        this.log.debug("Index is: {}", (Object)this.searchguardIndex);
    }

    public Map<String, Tuple<Settings, Long>> load(final String[] events, long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        final CountDownLatch latch = new CountDownLatch(events.length);
        final HashMap<String, Tuple<Settings, Long>> rs = new HashMap<String, Tuple<Settings, Long>>(events.length);
        this.loadAsync(events, new ConfigCallback(){

            @Override
            public void success(String type, Settings settings, Long version) {
                if (latch.getCount() <= 0L) {
                    ConfigurationLoader.this.log.error("Latch already counted down (for {} of {})  (index={})", (Object)type, (Object)Arrays.toString(events), (Object)ConfigurationLoader.this.searchguardIndex);
                }
                rs.put(type, new Tuple((Object)settings, (Object)version));
                latch.countDown();
                if (ConfigurationLoader.this.log.isDebugEnabled()) {
                    ConfigurationLoader.this.log.debug("Received config for {} (of {}) with current latch value={}", (Object)type, (Object)Arrays.toString(events), (Object)latch.getCount());
                }
            }

            @Override
            public void singleFailure(MultiGetResponse.Failure failure) {
                ConfigurationLoader.this.log.error("Failure {} retrieving configuration for {} (index={})", (Object)(failure == null ? null : failure.getMessage()), (Object)Arrays.toString(events), (Object)ConfigurationLoader.this.searchguardIndex);
            }

            @Override
            public void noData(String type) {
                ConfigurationLoader.this.log.error("No data for {} while retrieving configuration for {}  (index={})", (Object)type, (Object)Arrays.toString(events), (Object)ConfigurationLoader.this.searchguardIndex);
            }

            @Override
            public void failure(Throwable t) {
                ConfigurationLoader.this.log.error("Exception {} while retrieving configuration for {}  (index={})", (Object)t, (Object)t.toString(), (Object)Arrays.toString(events), (Object)ConfigurationLoader.this.searchguardIndex);
            }
        });
        if (!latch.await(timeout, timeUnit)) {
            throw new TimeoutException("Timeout after " + timeout + "" + (Object)((Object)timeUnit) + " while retrieving configuration for " + Arrays.toString(events) + "(index=" + this.searchguardIndex + ")");
        }
        return rs;
    }

    public void loadAsync(String[] events, final ConfigCallback callback) {
        if (events == null || events.length == 0) {
            this.log.warn("No config events requested to load");
            return;
        }
        MultiGetRequest mget = new MultiGetRequest();
        for (int i = 0; i < events.length; ++i) {
            String event = events[i];
            mget.add(this.searchguardIndex, event, "0");
        }
        mget.refresh(true);
        mget.realtime(true);
        try (ThreadContext.StoredContext ctx = this.threadContext.stashContext();){
            this.threadContext.putHeader("_sg_conf_request", "true");
            this.client.multiGet(mget, (ActionListener)new ActionListener<MultiGetResponse>(){

                public void onResponse(MultiGetResponse response) {
                    MultiGetItemResponse[] responses = response.getResponses();
                    for (int i = 0; i < responses.length; ++i) {
                        MultiGetItemResponse singleResponse = responses[i];
                        if (singleResponse != null && !singleResponse.isFailed()) {
                            GetResponse singleGetResponse = singleResponse.getResponse();
                            if (singleGetResponse.isExists() && !singleGetResponse.isSourceEmpty()) {
                                Long version = singleGetResponse.getVersion();
                                Settings _settings = ConfigurationLoader.this.toSettings(singleGetResponse.getSourceAsBytesRef(), singleGetResponse.getType());
                                if (_settings != null) {
                                    callback.success(singleGetResponse.getType(), _settings, version);
                                    continue;
                                }
                                ConfigurationLoader.this.log.error("Cannot parse settings for " + singleGetResponse.getType());
                                continue;
                            }
                            callback.noData(singleGetResponse.getType());
                            continue;
                        }
                        callback.singleFailure(singleResponse == null ? null : singleResponse.getFailure());
                    }
                }

                public void onFailure(Exception e) {
                    callback.failure(e);
                }
            });
        }
    }

    private Settings toSettings(BytesReference ref, String type) {
        if (ref == null || ref.length() == 0) {
            return null;
        }
        try (XContentParser parser = null;){
            parser = XContentHelper.createParser((NamedXContentRegistry)NamedXContentRegistry.EMPTY, (BytesReference)ref, (XContentType)XContentType.JSON);
            parser.nextToken();
            parser.nextToken();
            if (!type.equals(parser.currentName())) {
                Settings settings = null;
                return settings;
            }
            parser.nextToken();
            Settings settings = Settings.builder().put(new JsonSettingsLoader(true).load(parser.binaryValue())).build();
            return settings;
        }
    }
}

