/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.kibana.DocumentBuilder;
import io.fabric8.elasticsearch.plugin.kibana.IndexMappingLoader;
import io.fabric8.elasticsearch.plugin.kibana.KibanaUtils;
import io.fabric8.elasticsearch.plugin.model.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;

public class KibanaSeed
implements ConfigurationSettings {
    private static final String CONFIG_DOC_TYPE = "config";
    private static final String INDICIES_TYPE = "index-pattern";
    private static final Logger LOGGER = Loggers.getLogger(KibanaSeed.class);
    public static final String DEFAULT_INDEX_FIELD = "defaultIndex";
    private final IndexMappingLoader mappingLoader;
    private final PluginClient pluginClient;
    private final String defaultKibanaIndex;
    private final PluginSettings settings;
    private final KibanaUtils kibanaUtils;

    public KibanaSeed(PluginSettings settings, IndexMappingLoader loader, PluginClient pluginClient, KibanaUtils kibanaUtils) {
        this.mappingLoader = loader;
        this.pluginClient = pluginClient;
        this.defaultKibanaIndex = settings.getDefaultKibanaIndex();
        this.settings = settings;
        this.kibanaUtils = kibanaUtils;
    }

    public void setDashboards(OpenshiftRequestContextFactory.OpenshiftRequestContext context, String kibanaVersion, String projectPrefix) {
        if (!this.pluginClient.indexExists(this.defaultKibanaIndex)) {
            LOGGER.debug("Default Kibana index '{}' does not exist. Skipping Kibana seeding", (Object)this.defaultKibanaIndex);
            return;
        }
        LOGGER.debug("Begin setDashboards:  projectPrefix '{}' for user '{}' projects '{}' kibanaIndex '{}'", (Object)projectPrefix, (Object)context.getUser(), context.getProjects(), (Object)context.getKibanaIndex());
        Object action = Tuple.tuple((Object)this.initialSeedKibanaIndex(context), (Object)Project.EMPTY);
        action = context.isOperationsUser() ? this.seedOperationsIndexPatterns(context, kibanaVersion) : this.seedUsersIndexPatterns(context, kibanaVersion);
        if (action.v2() != null && !Project.EMPTY.equals(action.v2())) {
            boolean defaultIndexPatternExists = this.pluginClient.documentExists(context.getKibanaIndex(), INDICIES_TYPE, ((Project)action.v2()).getName());
            GetResponse config = this.pluginClient.getDocument(context.getKibanaIndex(), CONFIG_DOC_TYPE, kibanaVersion);
            if (!defaultIndexPatternExists || !config.isExists() || StringUtils.isBlank((String)this.kibanaUtils.getDefaultIndexPattern(config))) {
                this.setDefaultProject(context.getKibanaIndex(), (Project)action.v2(), kibanaVersion);
                action = Tuple.tuple((Object)true, (Object)action.v2());
            }
        }
        if (((Boolean)action.v1()).booleanValue()) {
            this.pluginClient.refreshIndices(context.getKibanaIndex());
        }
    }

    private Tuple<Boolean, Project> seedOperationsIndexPatterns(OpenshiftRequestContextFactory.OpenshiftRequestContext context, String kibanaVersion) {
        boolean changed = false;
        for (String pattern : this.settings.getKibanaOpsIndexPatterns()) {
            if (this.pluginClient.documentExists(context.getKibanaIndex(), INDICIES_TYPE, pattern)) continue;
            LOGGER.trace("Creating index-pattern '{}'", (Object)pattern);
            String source = StringUtils.replace((String)this.mappingLoader.getOperationsMappingsTemplate(), (String)"$TITLE$", (String)pattern);
            this.pluginClient.createDocument(context.getKibanaIndex(), INDICIES_TYPE, pattern, source);
            changed = true;
        }
        String defaultPattern = this.settings.getKibanaOpsIndexPatterns().size() > 0 ? this.settings.getKibanaOpsIndexPatterns().iterator().next() : "";
        String indexPattern = this.kibanaUtils.getDefaultIndexPattern(context.getKibanaIndex(), defaultPattern);
        return Tuple.tuple((Object)changed, (Object)new Project(indexPattern, null));
    }

    private Tuple<Boolean, Project> seedUsersIndexPatterns(OpenshiftRequestContextFactory.OpenshiftRequestContext context, String kibanaVersion) {
        boolean changed = false;
        Project defaultProject = Project.EMPTY;
        Set<Project> projectsFromIndexPatterns = this.kibanaUtils.getProjectsFromIndexPatterns(context);
        LOGGER.debug("Found '{}' Index patterns for user", (Object)projectsFromIndexPatterns.size());
        Set<Project> projects = context.getProjects();
        List<Project> projectsWithIndices = this.filterProjectsWithIndices(projects);
        LOGGER.debug("projects for '{}' that have existing index patterns: '{}'", (Object)context.getUser(), projectsWithIndices);
        if (projectsWithIndices.isEmpty()) {
            projectsWithIndices.add(KibanaUtils.EMPTY_PROJECT);
        }
        Collections.sort(projectsWithIndices);
        if (projectsFromIndexPatterns.isEmpty()) {
            this.create(context.getKibanaIndex(), projectsWithIndices, projectsFromIndexPatterns);
            changed = true;
            defaultProject = projectsWithIndices.isEmpty() ? null : projectsWithIndices.get(0);
        } else {
            ArrayList<Project> common = new ArrayList<Project>(projectsFromIndexPatterns);
            common.retainAll(projectsWithIndices);
            projectsWithIndices.removeAll(common);
            projectsFromIndexPatterns.removeAll(common);
            if (!context.isOperationsUser()) {
                LOGGER.debug("user is not a cluster admin, ensure they don't keep/have the admin alias pattern");
                projectsFromIndexPatterns.add(KibanaUtils.ALL_ALIAS);
            }
            if (!projectsWithIndices.isEmpty() || !projectsFromIndexPatterns.isEmpty()) {
                changed = true;
            }
            this.create(context.getKibanaIndex(), projectsWithIndices, projectsFromIndexPatterns);
            this.remove(context.getKibanaIndex(), projectsFromIndexPatterns);
            common.addAll(projectsWithIndices);
            Collections.sort(common);
            String defaultIfNotSet = !common.isEmpty() ? ((Project)common.get(0)).getName() : Project.EMPTY.getName();
            String pattern = this.kibanaUtils.getDefaultIndexPattern(context.getKibanaIndex(), defaultIfNotSet);
            defaultProject = new Project(pattern, null);
        }
        return Tuple.tuple((Object)changed, (Object)defaultProject);
    }

    private List<Project> filterProjectsWithIndices(Set<Project> projects) {
        ArrayList<Project> result = new ArrayList<Project>(projects.size());
        for (Project project : projects) {
            String indexPattern = this.kibanaUtils.formatIndexPattern(project);
            if (!this.pluginClient.indexExists(indexPattern)) continue;
            result.add(project);
        }
        return result;
    }

    private boolean initialSeedKibanaIndex(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        try {
            String userIndex = context.getKibanaIndex();
            boolean kibanaIndexExists = this.pluginClient.indexExists(userIndex);
            LOGGER.debug("Kibana index '{}' exists? {}", (Object)userIndex, (Object)kibanaIndexExists);
            if (!kibanaIndexExists && !this.defaultKibanaIndex.equals(userIndex)) {
                LOGGER.debug("Copying '{}' to '{}'", (Object)this.defaultKibanaIndex, (Object)userIndex);
                Settings settings = Settings.builder().put("index.number_of_shards", 1).put("index.number_of_replicas", 0).build();
                this.pluginClient.copyIndex(this.defaultKibanaIndex, userIndex, settings, CONFIG_DOC_TYPE);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("Unable to create initial Kibana index", (Throwable)e);
        }
        return false;
    }

    private void setDefaultProject(String kibanaIndex, Project project, String kibanaVersion) {
        String source = new DocumentBuilder().defaultIndex(this.kibanaUtils.formatIndexPattern(project)).build();
        this.pluginClient.updateDocument(kibanaIndex, CONFIG_DOC_TYPE, kibanaVersion, source);
    }

    private void create(String kibanaIndex, List<Project> projects, Set<Project> projectsWithIndexPatterns) {
        LOGGER.trace("Creating index-patterns for projects: '{}'", projects);
        for (Project project : projects) {
            if (projectsWithIndexPatterns.contains(project)) {
                LOGGER.trace("Skipping creation of index-pattern for project '{}'. It already exists.", (Object)project);
                continue;
            }
            this.createIndexPattern(kibanaIndex, project, this.settings.getCdmProjectPrefix());
        }
    }

    private void remove(String kibanaIndex, Set<Project> projects) {
        for (Project project : projects) {
            this.pluginClient.deleteDocument(kibanaIndex, INDICIES_TYPE, this.kibanaUtils.formatIndexPattern(project));
        }
    }

    private void createIndexPattern(String kibanaIndex, Project project, String projectPrefix) {
        String indexPattern = this.kibanaUtils.formatIndexPattern(project);
        String source = project.equals(KibanaUtils.EMPTY_PROJECT) ? this.mappingLoader.getEmptyProjectMappingsTemplate() : this.mappingLoader.getApplicationMappingsTemplate();
        if (source != null) {
            LOGGER.trace("Creating index-pattern for project '{}'", (Object)project);
            source = source.replaceAll("\\$TITLE\\$", indexPattern);
            this.pluginClient.createDocument(kibanaIndex, INDICIES_TYPE, indexPattern, source);
        } else {
            LOGGER.debug("The source for the index mapping is null.  Skipping trying to create index pattern {}", (Object)indexPattern);
        }
    }
}

