/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.model.Project;
import org.apache.commons.lang.StringUtils;

public class ProjectRolesSyncStrategy
extends BaseRolesSyncStrategy {
    private final String cdmProjectPrefix;
    private final String kibanaIndexMode;
    private final String expires;

    public ProjectRolesSyncStrategy(SearchGuardRoles roles, String userProfilePrefix, String cdmProjectPrefix, String kibanaIndexMode, long expiresInMillies) {
        super(roles, userProfilePrefix);
        this.roles = roles;
        this.cdmProjectPrefix = cdmProjectPrefix;
        this.kibanaIndexMode = kibanaIndexMode;
        this.expires = String.valueOf(expiresInMillies);
    }

    @Override
    public void syncFromImpl(OpenshiftRequestContextFactory.OpenshiftRequestContext context, RolesBuilder builder) {
        for (Project project : context.getProjects()) {
            String projectName = String.format("%s_%s", "gen_project", project.getName().replace('.', '_'));
            String indexName = String.format("%s?%s?*", project.getName().replace('.', '?'), project.getUID());
            RoleBuilder role = new RoleBuilder(projectName).setActions(indexName, "*", PROJECT_ROLE_ACTIONS).expires(this.expires);
            if (StringUtils.isNotEmpty((String)this.cdmProjectPrefix)) {
                indexName = String.format("%s?%s?%s?*", this.cdmProjectPrefix.replace('.', '?'), project.getName().replace('.', '?'), project.getUID());
                role.setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
            }
            builder.addRole(role.build());
        }
        String kibanaRoleName = ProjectRolesSyncStrategy.formatKibanaRoleName(context);
        String kibanaIndexName = this.formatKibanaIndexName(context, this.kibanaIndexMode);
        RoleBuilder kibanaRole = new RoleBuilder(kibanaRoleName).setActions(kibanaIndexName, "*", KIBANA_ROLE_INDEX_ACTIONS);
        if (context.isOperationsUser()) {
            kibanaRole.setClusters(KIBANA_ROLE_CLUSTER_ACTIONS).setActions("*", "*", KIBANA_ROLE_ALL_INDEX_ACTIONS);
        } else {
            kibanaRole.expires(this.expires);
        }
        builder.addRole(kibanaRole.build());
        if (context.isOperationsUser()) {
            RoleBuilder opsKibanaRole = new RoleBuilder(kibanaRoleName).setClusters(KIBANA_ROLE_CLUSTER_ACTIONS).setActions(kibanaIndexName, "*", KIBANA_ROLE_INDEX_ACTIONS);
            builder.addRole(opsKibanaRole.build());
            RoleBuilder opsRole = new RoleBuilder("gen_project_operations").setClusters(OPERATIONS_ROLE_CLUSTER_ACTIONS).setActions("?operations?", "*", OPERATIONS_ROLE_OPERATIONS_ACTIONS).setActions("*?*?*", "*", OPERATIONS_ROLE_ANY_ACTIONS);
            builder.addRole(opsRole.build());
        }
    }
}

