/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.rest;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import java.util.List;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

class OpenShiftRestResponse
extends RestResponse {
    private final RestResponse response;
    private final BytesReference content;
    private static final Logger LOGGER = Loggers.getLogger(OpenShiftRestResponse.class);

    OpenShiftRestResponse(RestResponse response, OpenshiftRequestContextFactory.OpenshiftRequestContext context, String defaultKibanaIndex) {
        this.response = response;
        this.content = this.evaluateContentForKibanaIndex(response.content(), context, defaultKibanaIndex);
    }

    public String contentType() {
        return this.response.contentType();
    }

    public BytesReference content() {
        return this.content;
    }

    public RestStatus status() {
        return this.response.status();
    }

    public void copyHeaders(ElasticsearchException ex) {
        this.response.copyHeaders(ex);
    }

    public void addHeader(String name, String value) {
        this.response.addHeader(name, value);
    }

    public Map<String, List<String>> getHeaders() {
        return this.response.getHeaders();
    }

    private BytesReference evaluateContentForKibanaIndex(BytesReference contentRef, OpenshiftRequestContextFactory.OpenshiftRequestContext context, String defaultKibanaIndex) {
        if (context == null || context == OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY) {
            return contentRef;
        }
        String content = contentRef.utf8ToString();
        if (content.contains("_index\":\"" + context.getKibanaIndex())) {
            LOGGER.debug("Replacing the content that references the kibana index");
            String replaced = content.replaceAll("_index\":\"" + context.getKibanaIndex() + "\"", "_index\":\"" + defaultKibanaIndex + "\"");
            return new BytesArray(replaced);
        }
        return contentRef;
    }
}

