/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import com.github.zafarkhaja.semver.Version;
import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.PathNotFoundException;
import com.jayway.jsonpath.Predicate;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.model.Project;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.index.IndexNotFoundException;
import org.elasticsearch.search.SearchHit;

public class KibanaUtils {
    private static final Logger LOGGER = Loggers.getLogger(KibanaUtils.class);
    public static final String INDICIES_TYPE = "index-pattern";
    public static final Project ALL_ALIAS = new Project(".all", null);
    public static final Project EMPTY_PROJECT = new Project(".empty-project", null);
    private final PluginClient pluginClient;
    private String projectPrefix;
    private final Pattern reIndexPattern;
    private final Version defaultVersion;
    private final JsonPath defaultPath = JsonPath.compile((String)"$.defaultIndex", (Predicate[])new Predicate[0]);

    public KibanaUtils(PluginSettings settings, PluginClient pluginClient) {
        this.pluginClient = pluginClient;
        this.projectPrefix = StringUtils.isNotBlank((String)settings.getCdmProjectPrefix()) ? settings.getCdmProjectPrefix() : "";
        this.reIndexPattern = Pattern.compile("^" + this.projectPrefix + "\\.(?<name>[a-zA-Z0-9-]*)\\.(?<uid>.*)\\.\\*$");
        this.defaultVersion = Version.valueOf((String)"5.6.13");
    }

    public Set<Project> getProjectsFromIndexPatterns(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        HashSet<Project> patterns = new HashSet<Project>();
        SearchResponse response = this.pluginClient.search(context.getKibanaIndex(), INDICIES_TYPE);
        if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
            for (SearchHit hit : response.getHits().getHits()) {
                String id = hit.getId();
                Project project = this.getProjectFromIndexPattern(id);
                if (project.getName().equals(id) && !project.equals(ALL_ALIAS)) continue;
                patterns.add(project);
            }
        } else {
            LOGGER.debug("No index-mappings found in the kibana index '{}'", (Object)context.getKibanaIndex());
        }
        return patterns;
    }

    public Project getProjectFromIndexPattern(String index) {
        if (StringUtils.isEmpty((String)index)) {
            return Project.EMPTY;
        }
        Matcher matcher = this.reIndexPattern.matcher(index);
        if (matcher.matches()) {
            return new Project(matcher.group("name"), matcher.group("uid"));
        }
        return new Project(index, null);
    }

    public String formatIndexPattern(Project project) {
        String prefix;
        String string = prefix = StringUtils.isNotEmpty((String)this.projectPrefix) ? this.projectPrefix + "." : "";
        if (project.equals(ALL_ALIAS)) {
            return ALL_ALIAS.getName();
        }
        if (project.equals(EMPTY_PROJECT)) {
            return prefix + project.getName().substring(1) + ".*";
        }
        if (project.getUID() == null) {
            return project.getName() + (project.getName().endsWith(".*") ? "" : ".*");
        }
        String uid = project.getUID() != null ? "." + project.getUID() : "";
        return String.format("%s%s%s.*", prefix, project.getName(), uid);
    }

    public String getDefaultIndexPattern(String kibanaIndex, String defaultIfNotSet) {
        try {
            SearchResponse response = this.pluginClient.search(kibanaIndex, "config");
            long totalHits = response.getHits().getTotalHits();
            if (totalHits == 0L) {
                return defaultIfNotSet;
            }
            if (totalHits == 1L) {
                try {
                    String value = (String)this.defaultPath.read(response.getHits().getHits()[0].getSourceAsString());
                    return StringUtils.isNotEmpty((String)value) ? value : defaultIfNotSet;
                }
                catch (PathNotFoundException e) {
                    return defaultIfNotSet;
                }
            }
            HashMap<Version, String> patternMap = new HashMap<Version, String>();
            for (SearchHit hit : response.getHits().getHits()) {
                String source = hit.getSourceAsString();
                String defaultIndex = defaultIfNotSet;
                try {
                    defaultIndex = (String)this.defaultPath.read(source);
                }
                catch (PathNotFoundException pathNotFoundException) {
                    // empty catch block
                }
                patternMap.put(Version.valueOf((String)hit.getId()), defaultIndex);
            }
            ArrayList versions = new ArrayList(patternMap.keySet());
            Collections.sort(versions);
            if (versions.contains(this.defaultVersion)) {
                return StringUtils.defaultIfBlank((String)((String)patternMap.get(this.defaultVersion)), (String)"");
            }
            return (String)patternMap.get(versions.get(versions.size() - 1));
        }
        catch (IndexNotFoundException e) {
            return defaultIfNotSet;
        }
    }
}

