/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.model.Project;
import org.apache.commons.lang.StringUtils;

public class UserRolesSyncStrategy
extends BaseRolesSyncStrategy
implements RolesSyncStrategy {
    private final String cdmProjectPrefix;
    private final String kibanaIndexMode;
    private String expire;

    public UserRolesSyncStrategy(SearchGuardRoles roles, String userProfilePrefix, String cdmProjectPrefix, String kibanaIndexMode, long expiresInMillis) {
        super(roles, userProfilePrefix);
        this.cdmProjectPrefix = cdmProjectPrefix;
        this.kibanaIndexMode = kibanaIndexMode;
        this.expire = String.valueOf(expiresInMillis);
    }

    @Override
    protected void syncFromImpl(OpenshiftRequestContextFactory.OpenshiftRequestContext context, RolesBuilder builder) {
        String kibIndexName = this.formatKibanaIndexName(context, this.kibanaIndexMode);
        String kibRoleName = UserRolesSyncStrategy.formatKibanaRoleName(context);
        RoleBuilder kibRole = new RoleBuilder(kibRoleName).setClusterActions(KIBANA_ROLE_CLUSTER_ACTIONS).setActions(kibIndexName, "*", KIBANA_ROLE_INDEX_ACTIONS).expires(this.expire);
        builder.addRole(kibRole.build());
        if (context.isOperationsUser()) {
            RoleBuilder opsRole = new RoleBuilder("gen_project_operations").setClusters(OPERATIONS_ROLE_CLUSTER_ACTIONS).setActions("*", "*", OPERATIONS_ROLE_ANY_ACTIONS).expires(this.expire);
            builder.addRole(opsRole.build());
            return;
        }
        String roleName = UserRolesSyncStrategy.formatUserRoleName(context.getUser());
        RoleBuilder role = new RoleBuilder(roleName).setClusters(USER_ROLE_CLUSTER_ACTIONS).expires(this.expire);
        for (Project project : context.getProjects()) {
            String indexName = String.format("%s?%s?*", project.getName().replace('.', '?'), project.getUID());
            role.setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
            if (!StringUtils.isNotEmpty((String)this.cdmProjectPrefix)) continue;
            indexName = String.format("%s?%s?%s?*", this.cdmProjectPrefix.replace('.', '?'), project.getName().replace('.', '?'), project.getUID());
            role.setActions(indexName, "*", PROJECT_ROLE_ACTIONS);
        }
        builder.addRole(role.build());
    }
}

