/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.DecoderException;
import io.netty.handler.ssl.NotSslRecordException;
import java.util.Objects;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLHandshakeException;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardHttpServerTransport
extends SearchGuardSSLNettyHttpServerTransport {
    private final AuditLog auditLog;

    public SearchGuardHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, ThreadPool threadPool, SearchGuardKeyStore sgks, AuditLog auditLog, NamedXContentRegistry namedXContentRegistry, ValidatingDispatcher dispatcher) {
        super(settings, networkService, bigArrays, threadPool, sgks, namedXContentRegistry, dispatcher);
        this.auditLog = Objects.requireNonNull(auditLog);
    }

    protected void errorThrown(Throwable t, RestRequest request) {
        this.auditLog.logSSLException(request, t, null);
        super.errorThrown(t, request);
    }

    protected void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) throws Exception {
        if (this.lifecycle.started()) {
            if (cause instanceof DecoderException && cause != null) {
                cause = cause.getCause();
            }
            if (cause instanceof NotSslRecordException) {
                this.logger.warn("Someone ({}) speaks http plaintext instead of ssl, will close the channel", (Object)ctx.channel().remoteAddress());
                ctx.channel().close();
                return;
            }
            if (cause instanceof SSLException) {
                this.logger.error("SSL Problem " + cause.getMessage(), cause);
                ctx.channel().close();
                return;
            }
            if (cause instanceof SSLHandshakeException) {
                this.logger.error("Problem during handshake " + cause.getMessage());
                ctx.channel().close();
                return;
            }
        }
        super.exceptionCaught(ctx, cause);
    }
}

