/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.auth.internal;

import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.crypto.BCrypt;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import java.util.Arrays;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;

public class InternalAuthenticationBackend
implements AuthenticationBackend {
    private final ConfigurationRepository configurationRepository;

    public InternalAuthenticationBackend(ConfigurationRepository configurationRepository) {
        this.configurationRepository = configurationRepository;
    }

    @Override
    public boolean exists(User user) {
        String[] roles;
        Settings cfg = this.getConfigSettings();
        if (cfg == null) {
            return false;
        }
        String hashed = cfg.get(user.getName() + ".hash");
        if (hashed == null) {
            for (String username : cfg.names()) {
                String u = cfg.get(username + ".username");
                if (!user.getName().equals(u)) continue;
                hashed = cfg.get(username + ".hash");
                break;
            }
            if (hashed == null) {
                return false;
            }
        }
        if ((roles = cfg.getAsArray(user.getName() + ".roles", new String[0])) != null) {
            user.addRoles(Arrays.asList(roles));
        }
        return true;
    }

    @Override
    public User authenticate(AuthCredentials credentials) {
        byte[] password;
        Settings cfg = this.getConfigSettings();
        if (cfg == null) {
            throw new ElasticsearchSecurityException("Internal authentication backend not configured. May be Search Guard is not initialized. See https://github.com/floragunncom/search-guard-docs/blob/master/sgadmin.md", new Object[0]);
        }
        String hashed = cfg.get(credentials.getUsername() + ".hash");
        if (hashed == null) {
            for (String username : cfg.names()) {
                String u = cfg.get(username + ".username");
                if (!credentials.getUsername().equals(u)) continue;
                hashed = cfg.get(username + ".hash");
                break;
            }
            if (hashed == null) {
                throw new ElasticsearchSecurityException(credentials.getUsername() + " not found", new Object[0]);
            }
        }
        if ((password = credentials.getPassword()) == null || password.length == 0) {
            throw new ElasticsearchSecurityException("empty passwords not supported", new Object[0]);
        }
        if (BCrypt.checkpw(password, hashed)) {
            String[] roles = cfg.getAsArray(credentials.getUsername() + ".roles", new String[0]);
            return new User(credentials.getUsername(), Arrays.asList(roles));
        }
        throw new ElasticsearchSecurityException("password does not match", new Object[0]);
    }

    @Override
    public String getType() {
        return "internal";
    }

    private Settings getConfigSettings() {
        return this.configurationRepository.getConfiguration("internalusers");
    }
}

