/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.action.configupdate;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateNodeResponse;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.configuration.ConfigurationRepository;
import com.floragunn.searchguard.configuration.IndexBaseConfigurationRepository;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.elasticsearch.action.FailedNodeException;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.nodes.BaseNodeRequest;
import org.elasticsearch.action.support.nodes.TransportNodesAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;

public class TransportConfigUpdateAction
extends TransportNodesAction<ConfigUpdateRequest, ConfigUpdateResponse, NodeConfigUpdateRequest, ConfigUpdateNodeResponse> {
    private final Provider<BackendRegistry> backendRegistry;
    private final ConfigurationRepository configurationRepository;

    @Inject
    public TransportConfigUpdateAction(Settings settings, ThreadPool threadPool, ClusterService clusterService, TransportService transportService, IndexBaseConfigurationRepository configurationRepository, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, Provider<BackendRegistry> backendRegistry) {
        super(settings, "cluster:admin/searchguard/config/update", threadPool, clusterService, transportService, actionFilters, indexNameExpressionResolver, ConfigUpdateRequest::new, NodeConfigUpdateRequest::new, "management", ConfigUpdateNodeResponse.class);
        this.configurationRepository = configurationRepository;
        this.backendRegistry = backendRegistry;
    }

    protected NodeConfigUpdateRequest newNodeRequest(String nodeId, ConfigUpdateRequest request) {
        return new NodeConfigUpdateRequest(nodeId, request);
    }

    protected ConfigUpdateNodeResponse newNodeResponse() {
        return new ConfigUpdateNodeResponse(this.clusterService.localNode(), new String[0], null);
    }

    protected ConfigUpdateResponse newResponse(ConfigUpdateRequest request, List<ConfigUpdateNodeResponse> responses, List<FailedNodeException> failures) {
        return new ConfigUpdateResponse(this.clusterService.getClusterName(), responses, failures);
    }

    protected ConfigUpdateNodeResponse nodeOperation(NodeConfigUpdateRequest request) {
        Map<String, Settings> setn = this.configurationRepository.reloadConfiguration(Arrays.asList(request.request.getConfigTypes()));
        ((BackendRegistry)this.backendRegistry.get()).invalidateCache();
        return new ConfigUpdateNodeResponse(this.clusterService.localNode(), setn.keySet().toArray(new String[0]), null);
    }

    public static class NodeConfigUpdateRequest
    extends BaseNodeRequest {
        ConfigUpdateRequest request;

        public NodeConfigUpdateRequest() {
        }

        public NodeConfigUpdateRequest(String nodeId, ConfigUpdateRequest request) {
            super(nodeId);
            this.request = request;
        }

        public void readFrom(StreamInput in) throws IOException {
            super.readFrom(in);
            this.request = new ConfigUpdateRequest();
            this.request.readFrom(in);
        }

        public void writeTo(StreamOutput out) throws IOException {
            super.writeTo(out);
            this.request.writeTo(out);
        }
    }
}

