/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.rest;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.rest.OpenShiftRestResponse;
import java.io.IOException;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;

public class RestChannelInterceptor
implements RestChannel {
    private final RestChannel channel;
    private final ThreadContext threadContext;
    private final String defaultKibanaIndex;

    public RestChannelInterceptor(RestChannel channel, ThreadContext threadContext, String defaultKibanaIndex) {
        this.channel = channel;
        this.threadContext = threadContext;
        this.defaultKibanaIndex = defaultKibanaIndex;
    }

    public XContentBuilder newErrorBuilder() throws IOException {
        return this.channel.newErrorBuilder();
    }

    public XContentBuilder newBuilder() throws IOException {
        return this.channel.newBuilder();
    }

    public XContentBuilder newBuilder(XContentType contentType, boolean useFiltering) throws IOException {
        return this.channel.newBuilder(contentType, useFiltering);
    }

    public BytesStreamOutput bytesOutput() {
        return this.channel.bytesOutput();
    }

    public RestRequest request() {
        return this.channel.request();
    }

    public boolean detailedErrorsEnabled() {
        return this.channel.detailedErrorsEnabled();
    }

    public void sendResponse(RestResponse response) {
        OpenshiftRequestContextFactory.OpenshiftRequestContext context = (OpenshiftRequestContextFactory.OpenshiftRequestContext)this.threadContext.getTransient("x-openshift-request-context");
        this.channel.sendResponse((RestResponse)new OpenShiftRestResponse(response, context, this.defaultKibanaIndex));
    }
}

