/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.transport;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLRequestHandler;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import com.floragunn.searchguard.user.User;
import com.google.common.base.Strings;
import java.net.InetSocketAddress;
import java.security.cert.X509Certificate;
import java.util.Objects;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class SearchGuardRequestHandler<T extends TransportRequest>
extends SearchGuardSSLRequestHandler<T> {
    private final BackendRegistry backendRegistry;
    private final AuditLog auditLog;
    private final InterClusterRequestEvaluator requestEvalProvider;
    private final ClusterService cs;

    SearchGuardRequestHandler(String action, TransportRequestHandler<T> actualHandler, ThreadPool threadPool, BackendRegistry backendRegistry, AuditLog auditLog, PrincipalExtractor principalExtractor, InterClusterRequestEvaluator requestEvalProvider, ClusterService cs) {
        super(action, actualHandler, threadPool, principalExtractor);
        this.backendRegistry = backendRegistry;
        this.auditLog = auditLog;
        this.requestEvalProvider = requestEvalProvider;
        this.cs = cs;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void messageReceivedDecorate(T request, TransportRequestHandler<T> handler, TransportChannel transportChannel, Task task) throws Exception {
        try (ThreadContext.StoredContext sgContext = this.getThreadContext().newStoredContext(false);){
            String ct = (String)this.getThreadContext().getTransient("_sg_channel_type");
            if (transportChannel.getChannelType() == null) {
                throw new RuntimeException("Can not determine channel type (null)");
            }
            this.getThreadContext().putTransient("_sg_action_name", (Object)transportChannel.action());
            if (ct == null) {
                this.getThreadContext().putTransient("_sg_channel_type", (Object)transportChannel.getChannelType());
            } else if (!ct.equals(transportChannel.getChannelType())) {
                throw new RuntimeException("channel type mismtach " + ct + "!=" + transportChannel.getChannelType());
            }
            if (transportChannel.getChannelType().equals("local") || transportChannel.getChannelType().equals("direct")) {
                String originalRemoteAddress;
                String userHeader = this.getThreadContext().getHeader("_sg_user_header");
                if (!Strings.isNullOrEmpty((String)userHeader)) {
                    this.getThreadContext().putTransient("_sg_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                if (!Strings.isNullOrEmpty((String)(originalRemoteAddress = this.getThreadContext().getHeader("_sg_remote_address_header")))) {
                    this.getThreadContext().putTransient("_sg_remote_address", (Object)new InetSocketTransportAddress((InetSocketAddress)Base64Helper.deserializeObject(originalRemoteAddress)));
                }
                super.messageReceivedDecorate(request, handler, transportChannel, task);
                return;
            }
            if (!(HeaderHelper.isInterClusterRequest(this.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.getThreadContext()) || transportChannel.action().equals("internal:transport/handshake") || !transportChannel.action().startsWith("internal:") && !transportChannel.action().contains("["))) {
                this.auditLog.logMissingPrivileges(transportChannel.action(), (TransportRequest)request);
                this.log.error("Internal or shard requests (" + transportChannel.action() + ") not allowed from a non-server node for transport type " + transportChannel.getChannelType());
                transportChannel.sendResponse((Exception)((Object)new ElasticsearchSecurityException("Internal or shard requests not allowed from a non-server node for transport type " + transportChannel.getChannelType(), new Object[0])));
                return;
            }
            String principal = null;
            principal = (String)this.getThreadContext().getTransient("_sg_ssl_transport_principal");
            if (principal == null) {
                ElasticsearchSecurityException ex = new ElasticsearchSecurityException("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". Search Guard needs the Search Guard SSL plugin to be installed", new Object[0]);
                this.auditLog.logSSLException((TransportRequest)request, (Throwable)ex, transportChannel.action());
                this.log.error("No SSL client certificates found for transport type " + transportChannel.getChannelType() + ". Search Guard needs the Search Guard SSL plugin to be installed");
                transportChannel.sendResponse((Exception)((Object)ex));
                return;
            }
            if (HeaderHelper.isInterClusterRequest(this.getThreadContext()) || HeaderHelper.isTrustedClusterRequest(this.getThreadContext())) {
                String userHeader = this.getThreadContext().getHeader("_sg_user_header");
                if (Strings.isNullOrEmpty((String)userHeader)) {
                    this.getThreadContext().putTransient("_sg_user", (Object)User.SG_INTERNAL);
                } else {
                    this.getThreadContext().putTransient("_sg_user", (Object)Objects.requireNonNull((User)Base64Helper.deserializeObject(userHeader)));
                }
                String originalRemoteAddress = this.getThreadContext().getHeader("_sg_remote_address_header");
                if (!Strings.isNullOrEmpty((String)originalRemoteAddress)) {
                    this.getThreadContext().putTransient("_sg_remote_address", (Object)new InetSocketTransportAddress((InetSocketAddress)Base64Helper.deserializeObject(originalRemoteAddress)));
                } else {
                    this.getThreadContext().putTransient("_sg_remote_address", (Object)((InetSocketTransportAddress)request.remoteAddress()));
                }
            } else {
                if (SSLRequestHelper.containsBadHeader((ThreadContext)this.getThreadContext(), (String)"_sg_")) {
                    ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
                    this.auditLog.logBadHeaders((TransportRequest)request);
                    this.log.error((Object)exception);
                    transportChannel.sendResponse((Exception)exception);
                    return;
                }
                User user = this.backendRegistry.authenticate((TransportRequest)request, transportChannel, principal);
                if (user == null) {
                    this.log.error("Cannot authenticate {}", (Object)((User)this.getThreadContext().getTransient("_sg_user")));
                    transportChannel.sendResponse((Exception)((Object)new ElasticsearchSecurityException("Cannot authenticate " + this.getThreadContext().getTransient("_sg_user"), new Object[0])));
                    return;
                }
                this.getThreadContext().putTransient("_sg_user", (Object)user);
                TransportAddress originalRemoteAddress = request.remoteAddress();
                if (originalRemoteAddress != null && originalRemoteAddress instanceof InetSocketTransportAddress) {
                    this.getThreadContext().putTransient("_sg_remote_address", (Object)originalRemoteAddress);
                } else {
                    this.log.error("Request has no proper remote address {}", (Object)originalRemoteAddress);
                    transportChannel.sendResponse((Exception)new ElasticsearchException("Request has no proper remote address", new Object[0]));
                    return;
                }
            }
            super.messageReceivedDecorate(request, handler, transportChannel, task);
        }
    }

    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) throws Exception {
        boolean isInterClusterRequest = this.requestEvalProvider.isInterClusterRequest(request, localCerts, peerCerts, principal);
        if (isInterClusterRequest) {
            boolean fromTn = Boolean.parseBoolean(this.getThreadContext().getHeader("_sg_header_tn"));
            if (fromTn || this.cs.getClusterName().value().equals(this.getThreadContext().getHeader("_sg_remotecn"))) {
                if (this.log.isTraceEnabled() && !action.startsWith("internal:")) {
                    this.log.trace("Is inter cluster request ({}/{}/{})", (Object)action, request.getClass(), (Object)request.remoteAddress());
                }
                this.getThreadContext().putTransient("_sg_ssl_transport_intercluster_request", (Object)Boolean.TRUE);
            } else {
                this.getThreadContext().putTransient("_sg_ssl_transport_trustedcluster_request", (Object)Boolean.TRUE);
            }
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Is not an inter cluster request");
        }
        super.addAdditionalContextValues(action, request, localCerts, peerCerts, principal);
    }

    protected void errorThrown(Throwable t, TransportRequest request, String action) {
        this.auditLog.logSSLException(request, t, action);
    }
}

