/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auditlog.NullAuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.auth.internal.InternalAuthenticationBackend;
import com.floragunn.searchguard.configuration.ActionGroupHolder;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.configuration.IndexBaseConfigurationRepository;
import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.configuration.PrivilegesInterceptor;
import com.floragunn.searchguard.configuration.SearchGuardIndexSearcherWrapper;
import com.floragunn.searchguard.filter.SearchGuardFilter;
import com.floragunn.searchguard.filter.SearchGuardRestFilter;
import com.floragunn.searchguard.http.SearchGuardHttpServerTransport;
import com.floragunn.searchguard.http.SearchGuardNonSslHttpServerTransport;
import com.floragunn.searchguard.http.XFFResolver;
import com.floragunn.searchguard.rest.KibanaInfoAction;
import com.floragunn.searchguard.rest.SearchGuardInfoAction;
import com.floragunn.searchguard.ssl.DefaultSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.ExternalSearchGuardKeyStore;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.http.netty.AuditErrorHandler;
import com.floragunn.searchguard.ssl.http.netty.ValidatingDispatcher;
import com.floragunn.searchguard.ssl.rest.SearchGuardSSLInfoAction;
import com.floragunn.searchguard.ssl.transport.DefaultPrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.transport.SearchGuardSSLNettyTransport;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.support.ReflectionHelper;
import com.floragunn.searchguard.support.WildcardMatcher;
import com.floragunn.searchguard.transport.DefaultInterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.SearchGuardInterceptor;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.Lists;
import io.netty.handler.ssl.OpenSsl;
import io.netty.util.internal.PlatformDependent;
import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.search.QueryCachingPolicy;
import org.apache.lucene.search.Weight;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.GenericAction;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.Lifecycle;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.component.LifecycleListener;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.inject.Provider;
import org.elasticsearch.common.inject.util.Providers;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.IndexSettings;
import org.elasticsearch.index.cache.query.QueryCache;
import org.elasticsearch.index.shard.IndexSearcherWrapper;
import org.elasticsearch.index.shard.SearchOperationListener;
import org.elasticsearch.indices.IndicesQueryCache;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.repositories.RepositoriesService;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.search.internal.ScrollContext;
import org.elasticsearch.search.internal.SearchContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.RemoteClusterService;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.watcher.ResourceWatcherService;

public final class SearchGuardPlugin
extends Plugin
implements ActionPlugin,
NetworkPlugin {
    private static final String FLS_DLS_INDEX_SEARCHER_WRAPPER_CLASS = "com.floragunn.searchguard.configuration.SearchGuardFlsDlsIndexSearcherWrapper";
    private final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    private static final String CLIENT_TYPE = "client.type";
    private final Settings settings;
    private final boolean client;
    private final boolean httpSSLEnabled;
    private final boolean tribeNodeClient;
    private final boolean dlsFlsAvailable;
    private final Constructor<?> dlsFlsConstructor;
    private final SearchGuardKeyStore sgks;
    private SearchGuardRestFilter sgRestHandler;
    private SearchGuardInterceptor sgi;
    private PrincipalExtractor principalExtractor;
    private PrivilegesEvaluator evaluator;
    private ThreadPool threadPool;
    private IndexBaseConfigurationRepository cr;
    private AdminDNs adminDns;
    private ClusterService cs;
    private AuditLog auditLog;
    private Client localClient;
    private final boolean disabled;
    private static final String LB = System.lineSeparator();

    public SearchGuardPlugin(Settings settings) {
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                System.setProperty("es.set.netty.runtime.available.processors", "false");
                return null;
            }
        });
        this.disabled = settings.getAsBoolean("searchguard.disabled", Boolean.valueOf(false));
        if (this.disabled) {
            this.settings = null;
            this.client = false;
            this.httpSSLEnabled = false;
            this.tribeNodeClient = false;
            this.dlsFlsAvailable = false;
            this.dlsFlsConstructor = null;
            this.sgks = null;
            this.log.warn("Search Guard plugin installed but disabled. This can expose your configuration (including passwords) to the public.");
            return;
        }
        this.log.info("Clustername: {}", (Object)settings.get("cluster.name", "elasticsearch"));
        String licenseText = LB + "### LICENSE NOTICE Search Guard ###" + LB + LB + "If you use one or more of the following features in production" + LB + "make sure you have a valid Search Guard license" + LB + "(See https://floragunn.com/searchguard-validate-license)" + LB + LB + "* Kibana Multitenancy" + LB + "* LDAP authentication/authorization" + LB + "* Active Directory authentication/authorization" + LB + "* REST Management API" + LB + "* JSON Web Token (JWT) authentication/authorization" + LB + "* Kerberos authentication/authorization" + LB + "* Document- and Fieldlevel Security (DLS/FLS)" + LB + "* Auditlogging" + LB + LB + "In case of any doubt mail to <sales@floragunn.com>" + LB + "###################################";
        if (!Boolean.getBoolean("sg.display_lic_none")) {
            if (!Boolean.getBoolean("sg.display_lic_only_stdout")) {
                this.log.warn(licenseText);
                System.err.println(licenseText);
            }
            System.out.println(licenseText);
        }
        if (!settings.getAsBoolean("searchguard.ssl.transport.enabled", Boolean.valueOf(true)).booleanValue()) {
            throw new IllegalStateException("searchguard.ssl.transport.enabled must be set to 'true'");
        }
        String rejectClientInitiatedRenegotiation = System.getProperty("jdk.tls.rejectClientInitiatedRenegotiation");
        if (!Boolean.parseBoolean(rejectClientInitiatedRenegotiation)) {
            String renegoMsg = "Consider setting -Djdk.tls.rejectClientInitiatedRenegotiation=true to prevent DoS attacks through client side initiated TLS renegotiation.";
            this.log.warn("Consider setting -Djdk.tls.rejectClientInitiatedRenegotiation=true to prevent DoS attacks through client side initiated TLS renegotiation.");
            System.out.println("Consider setting -Djdk.tls.rejectClientInitiatedRenegotiation=true to prevent DoS attacks through client side initiated TLS renegotiation.");
            System.err.println("Consider setting -Djdk.tls.rejectClientInitiatedRenegotiation=true to prevent DoS attacks through client side initiated TLS renegotiation.");
        } else {
            this.log.debug("Client side initiated TLS renegotiation disabled. This can prevent DoS attacks. (jdk.tls.rejectClientInitiatedRenegotiation is true).");
        }
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        AccessController.doPrivileged(new PrivilegedAction<Object>(){

            @Override
            public Object run() {
                PlatformDependent.newFixedMpscQueue((int)1);
                OpenSsl.isAvailable();
                return null;
            }
        });
        this.settings = settings;
        this.client = !"node".equals(this.settings.get(CLIENT_TYPE, "node"));
        boolean tribeNode = this.settings.getAsBoolean("action.master.force_local", Boolean.valueOf(false)) != false && this.settings.getByPrefix("tribe").getAsMap().size() > 0;
        this.tribeNodeClient = this.settings.get("tribe.name", null) != null;
        this.httpSSLEnabled = settings.getAsBoolean("searchguard.ssl.http.enabled", Boolean.valueOf(false));
        this.log.info("Node [{}] is a transportClient: {}/tribeNode: {}/tribeNodeClient: {}", (Object)settings.get("node.name"), (Object)this.client, (Object)tribeNode, (Object)this.tribeNodeClient);
        if (!this.client && ReflectionHelper.canLoad(FLS_DLS_INDEX_SEARCHER_WRAPPER_CLASS)) {
            try {
                this.dlsFlsConstructor = ReflectionHelper.load(FLS_DLS_INDEX_SEARCHER_WRAPPER_CLASS).getConstructor(IndexService.class, Settings.class);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to enable FLS/DLS", e);
            }
            this.dlsFlsAvailable = this.dlsFlsConstructor != null;
            this.log.info("FLS/DLS module available: " + this.dlsFlsAvailable);
        } else {
            this.dlsFlsAvailable = false;
            this.dlsFlsConstructor = null;
            this.log.info("FLS/DLS module not available");
        }
        this.sgks = ExternalSearchGuardKeyStore.hasExternalSslContext((Settings)settings) ? new ExternalSearchGuardKeyStore(settings) : new DefaultSearchGuardKeyStore(settings);
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>(1);
        if (!(this.client || this.tribeNodeClient || this.disabled)) {
            handlers.add((RestHandler)new SearchGuardInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
            handlers.add((RestHandler)new KibanaInfoAction(settings, restController, Objects.requireNonNull(this.evaluator), Objects.requireNonNull(this.threadPool)));
            handlers.add((RestHandler)new SearchGuardSSLInfoAction(settings, restController, this.sgks, Objects.requireNonNull(this.principalExtractor)));
            if (ReflectionHelper.canLoad("com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions")) {
                try {
                    Collection apiHandler = (Collection)ReflectionHelper.load("com.floragunn.searchguard.dlic.rest.api.SearchGuardRestApiActions").getDeclaredMethod("getHandler", Settings.class, RestController.class, Client.class, AdminDNs.class, IndexBaseConfigurationRepository.class, ClusterService.class, PrincipalExtractor.class).invoke(null, settings, restController, this.localClient, this.adminDns, this.cr, this.cs, this.principalExtractor);
                    handlers.addAll(apiHandler);
                    this.log.debug("Added {} management rest handler", (Object)apiHandler.size());
                }
                catch (Throwable ex) {
                    this.log.error("Failed to register SearchGuardRestApiActions, management API not available", ex);
                }
            }
        }
        return handlers;
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        if (this.client || this.disabled) {
            return rh -> rh;
        }
        return rh -> this.sgRestHandler.wrap((RestHandler)rh);
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> actions = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>(1);
        if (!this.tribeNodeClient && !this.disabled) {
            actions.add((ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>)new ActionPlugin.ActionHandler((GenericAction)ConfigUpdateAction.INSTANCE, TransportConfigUpdateAction.class, new Class[0]));
        }
        return actions;
    }

    private IndexSearcherWrapper loadFlsDlsIndexSearcherWrapper(IndexService indexService) {
        try {
            IndexSearcherWrapper flsdlsWrapper = (IndexSearcherWrapper)this.dlsFlsConstructor.newInstance(indexService, this.settings);
            if (this.log.isDebugEnabled()) {
                this.log.debug("FLS/DLS enabled for index {}", (Object)indexService.index().getName());
            }
            return flsdlsWrapper;
        }
        catch (Exception ex) {
            throw new RuntimeException("Failed to enable FLS/DLS", ex);
        }
    }

    public void onIndexModule(IndexModule indexModule) {
        if (!this.disabled && !this.client) {
            if (this.dlsFlsAvailable) {
                indexModule.setSearcherWrapper(indexService -> this.loadFlsDlsIndexSearcherWrapper(indexService));
                indexModule.forceQueryCacheProvider((indexSettings, nodeCache) -> new QueryCache((IndexSettings)indexSettings, (IndicesQueryCache)nodeCache){
                    final /* synthetic */ IndexSettings val$indexSettings;
                    final /* synthetic */ IndicesQueryCache val$nodeCache;
                    {
                        this.val$indexSettings = indexSettings;
                        this.val$nodeCache = indicesQueryCache;
                    }

                    public Index index() {
                        return this.val$indexSettings.getIndex();
                    }

                    public void close() throws ElasticsearchException {
                        this.clear("close");
                    }

                    public void clear(String reason) {
                        this.val$nodeCache.clearIndex(this.index().getName());
                    }

                    public Weight doCache(Weight weight, QueryCachingPolicy policy) {
                        Map allowedFlsFields = (Map)((Object)HeaderHelper.deserializeSafeFromHeader(SearchGuardPlugin.this.threadPool.getThreadContext(), "_sg_fls_fields"));
                        if (this.evalMap(allowedFlsFields, this.index().getName()) != null) {
                            return weight;
                        }
                        return this.val$nodeCache.doCache(weight, policy);
                    }

                    private String evalMap(Map<String, Set<String>> map, String index) {
                        if (map == null) {
                            return null;
                        }
                        if (map.get(index) != null) {
                            return index;
                        }
                        if (map.get("*") != null) {
                            return "*";
                        }
                        if (map.get("_all") != null) {
                            return "_all";
                        }
                        for (String key : map.keySet()) {
                            if (!WildcardMatcher.containsWildcard(key) || !WildcardMatcher.match(key, index)) continue;
                            return key;
                        }
                        return null;
                    }
                });
            } else {
                indexModule.setSearcherWrapper(indexService -> new SearchGuardIndexSearcherWrapper(indexService, this.settings));
            }
            indexModule.addSearchOperationListener(new SearchOperationListener(){

                public void onNewScrollContext(SearchContext context) {
                    ScrollContext scrollContext = context.scrollContext();
                    if (scrollContext != null) {
                        User user = (User)SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_user");
                        if (user == null || user.equals(User.SG_INTERNAL) && (HeaderHelper.isDirectRequest(SearchGuardPlugin.this.threadPool.getThreadContext()) || HeaderHelper.isInterClusterRequest(SearchGuardPlugin.this.threadPool.getThreadContext()))) {
                            scrollContext.putInContext("_sg_scroll_auth_local", (Object)Boolean.TRUE);
                        } else {
                            scrollContext.putInContext("_sg_scroll_auth", (Object)user);
                        }
                    }
                }

                public void validateSearchContext(SearchContext context, TransportRequest transportRequest) {
                    ScrollContext scrollContext = context.scrollContext();
                    if (scrollContext != null) {
                        Object _isLocal = scrollContext.getFromContext("_sg_scroll_auth_local");
                        Object _user = scrollContext.getFromContext("_sg_scroll_auth");
                        if (_user != null && _user instanceof User) {
                            User scrollUser = (User)_user;
                            User currentUser = (User)SearchGuardPlugin.this.threadPool.getThreadContext().getTransient("_sg_user");
                            if (!scrollUser.equals(currentUser)) {
                                SearchGuardPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest);
                                SearchGuardPlugin.this.log.error("Wrong user {} in scroll context, expected {}", (Object)scrollUser, (Object)currentUser);
                                throw new ElasticsearchSecurityException("Wrong user in scroll context", RestStatus.FORBIDDEN, new Object[0]);
                            }
                        } else if (_isLocal != Boolean.TRUE) {
                            SearchGuardPlugin.this.auditLog.logMissingPrivileges("indices:data/read/scroll", transportRequest);
                            throw new ElasticsearchSecurityException("No user in scroll context", RestStatus.FORBIDDEN, new Object[0]);
                        }
                    }
                }
            });
        }
    }

    public List<Class<? extends ActionFilter>> getActionFilters() {
        ArrayList<Class<? extends ActionFilter>> filters = new ArrayList<Class<? extends ActionFilter>>(1);
        if (!(this.tribeNodeClient || this.client || this.disabled)) {
            filters.add(SearchGuardFilter.class);
        }
        return filters;
    }

    public List<TransportInterceptor> getTransportInterceptors(ThreadContext threadContext) {
        ArrayList<TransportInterceptor> interceptors = new ArrayList<TransportInterceptor>(1);
        if (!(this.client || this.tribeNodeClient || this.disabled)) {
            interceptors.add(new TransportInterceptor(){

                public <T extends TransportRequest> TransportRequestHandler<T> interceptHandler(final String action, String executor, boolean forceExecution, final TransportRequestHandler<T> actualHandler) {
                    return new TransportRequestHandler<T>(){

                        public void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
                            SearchGuardPlugin.this.sgi.getHandler(action, actualHandler).messageReceived((TransportRequest)request, channel, task);
                        }

                        public void messageReceived(T request, TransportChannel channel) throws Exception {
                            SearchGuardPlugin.this.sgi.getHandler(action, actualHandler).messageReceived((TransportRequest)request, channel);
                        }
                    };
                }

                public TransportInterceptor.AsyncSender interceptSender(final TransportInterceptor.AsyncSender sender) {
                    return new TransportInterceptor.AsyncSender(){

                        public <T extends TransportResponse> void sendRequest(Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
                            SearchGuardPlugin.this.sgi.sendRequestDecorate(sender, connection, action, request, options, handler);
                        }
                    };
                }
            });
        }
        return interceptors;
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        HashMap<String, Supplier<Transport>> transports = new HashMap<String, Supplier<Transport>>();
        if (!this.disabled) {
            transports.put("com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport", () -> new SearchGuardSSLNettyTransport(settings, threadPool, networkService, bigArrays, namedWriteableRegistry, circuitBreakerService, this.sgks));
        }
        return transports;
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry xContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        HashMap<String, Supplier<HttpServerTransport>> httpTransports = new HashMap<String, Supplier<HttpServerTransport>>(1);
        if (!this.disabled) {
            if (!this.client && this.httpSSLEnabled && !this.tribeNodeClient) {
                ValidatingDispatcher validatingDispatcher = new ValidatingDispatcher(threadPool.getThreadContext(), dispatcher, settings);
                SearchGuardHttpServerTransport sghst = new SearchGuardHttpServerTransport(settings, networkService, bigArrays, threadPool, this.sgks, this.auditLog, xContentRegistry, validatingDispatcher);
                validatingDispatcher.setAuditErrorHandler((AuditErrorHandler)sghst);
                httpTransports.put("com.floragunn.searchguard.http.SearchGuardHttpServerTransport", () -> sghst);
            } else if (!this.client && !this.tribeNodeClient) {
                httpTransports.put("com.floragunn.searchguard.http.SearchGuardHttpServerTransport", () -> new SearchGuardNonSslHttpServerTransport(settings, networkService, bigArrays, threadPool, xContentRegistry, dispatcher));
            }
        }
        return httpTransports;
    }

    public Collection<Object> createComponents(Client localClient, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry xContentRegistry) {
        InterClusterRequestEvaluator interClusterRequestEvaluator;
        IndexNameExpressionResolver resolver;
        DlsFlsRequestValve dlsFlsValve;
        ArrayList<Object> components;
        block17: {
            this.threadPool = threadPool;
            this.cs = clusterService;
            this.localClient = localClient;
            components = new ArrayList<Object>();
            if (this.client || this.tribeNodeClient || this.disabled) {
                return components;
            }
            dlsFlsValve = new DlsFlsRequestValve.NoopDlsFlsRequestValve();
            try {
                Class<?> dlsFlsRequestValveClass = Class.forName("com.floragunn.searchguard.configuration.DlsFlsValveImpl");
                if (dlsFlsRequestValveClass != null) {
                    dlsFlsValve = (DlsFlsRequestValve)dlsFlsRequestValveClass.newInstance();
                    this.log.info("FLS/DLS valve bound");
                }
            }
            catch (Throwable e) {
                this.log.info("FLS/DLS valve not bound (noop) due to " + e);
            }
            resolver = new IndexNameExpressionResolver(this.settings);
            this.auditLog = new NullAuditLog();
            try {
                Class<?> auditLogImplClass = Class.forName("com.floragunn.searchguard.auditlog.impl.AuditLogImpl");
                if (auditLogImplClass != null) {
                    this.auditLog = (AuditLog)auditLogImplClass.getConstructor(Settings.class, Provider.class, ThreadPool.class, IndexNameExpressionResolver.class, Provider.class).newInstance(this.settings, Providers.of((Object)localClient), threadPool, resolver, Providers.of((Object)clusterService));
                    this.log.info("Auditlog available ({})", (Object)auditLogImplClass.getSimpleName());
                }
            }
            catch (Throwable e) {
                this.log.info("Auditlog not available due to " + e);
            }
            String DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS = DefaultInterClusterRequestEvaluator.class.getName();
            interClusterRequestEvaluator = new DefaultInterClusterRequestEvaluator(this.settings);
            String className = this.settings.get("searchguard.cert.intercluster_request_evaluator_class", DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS);
            this.log.debug("Using {} as intercluster request evaluator class", (Object)className);
            if (!DEFAULT_INTERCLUSTER_REQUEST_EVALUATOR_CLASS.equals(className)) {
                try {
                    Class<?> klass = Class.forName(className);
                    Constructor<?> constructor = klass.getConstructor(Settings.class);
                    interClusterRequestEvaluator = (InterClusterRequestEvaluator)constructor.newInstance(this.settings);
                }
                catch (Throwable e) {
                    this.log.error("Using DefaultInterClusterRequestEvaluator. Unable to instantiate {} ", (Object)e, (Object)className);
                    if (!this.log.isTraceEnabled()) break block17;
                    this.log.trace("Unable to instantiate InterClusterRequestEvaluator", e);
                }
            }
        }
        PrivilegesInterceptor privilegesInterceptor = new PrivilegesInterceptor(resolver, clusterService, localClient, threadPool);
        try {
            Class<?> privilegesInterceptorImplClass = Class.forName("com.floragunn.searchguard.configuration.PrivilegesInterceptorImpl");
            if (privilegesInterceptorImplClass != null) {
                privilegesInterceptor = (PrivilegesInterceptor)privilegesInterceptorImplClass.getConstructor(IndexNameExpressionResolver.class, ClusterService.class, Client.class, ThreadPool.class).newInstance(resolver, clusterService, localClient, threadPool);
                this.log.info("Privileges interceptor bound");
            }
        }
        catch (Throwable e) {
            this.log.info("Privileges interceptor not bound (noop) due to " + e);
        }
        this.adminDns = new AdminDNs(this.settings);
        String principalExtractorClass = this.settings.get("searchguard.ssl.transport.principal_extractor_class", null);
        if (principalExtractorClass == null) {
            this.principalExtractor = new DefaultPrincipalExtractor();
        } else {
            try {
                this.log.debug("Try to load and instantiate '{}'", (Object)principalExtractorClass);
                Class<?> principalExtractorClazz = Class.forName(principalExtractorClass);
                this.principalExtractor = (PrincipalExtractor)principalExtractorClazz.newInstance();
            }
            catch (Exception e) {
                this.log.error("Unable to load '{}' due to {}", (Object)e, (Object)principalExtractorClass, (Object)e.toString());
                throw new ElasticsearchException((Throwable)e);
            }
        }
        this.cr = (IndexBaseConfigurationRepository)IndexBaseConfigurationRepository.create(this.settings, threadPool, localClient, clusterService);
        InternalAuthenticationBackend iab = new InternalAuthenticationBackend(this.cr);
        XFFResolver xffResolver = new XFFResolver(threadPool);
        this.cr.subscribeOnChange("config", xffResolver);
        BackendRegistry backendRegistry = new BackendRegistry(this.settings, this.adminDns, xffResolver, iab, this.auditLog, threadPool);
        this.cr.subscribeOnChange("config", backendRegistry);
        ActionGroupHolder ah = new ActionGroupHolder(this.cr);
        this.evaluator = new PrivilegesEvaluator(clusterService, threadPool, this.cr, ah, resolver, this.auditLog, this.settings, privilegesInterceptor);
        SearchGuardFilter sgf = new SearchGuardFilter(this.settings, this.evaluator, this.adminDns, dlsFlsValve, this.auditLog, threadPool);
        this.sgi = new SearchGuardInterceptor(this.settings, threadPool, backendRegistry, this.auditLog, this.principalExtractor, interClusterRequestEvaluator, this.cs);
        components.add(this.principalExtractor);
        components.add(this.adminDns);
        components.add(this.cr);
        components.add(iab);
        components.add(xffResolver);
        components.add(backendRegistry);
        components.add(ah);
        components.add(this.evaluator);
        components.add(sgf);
        components.add(this.sgi);
        this.sgRestHandler = new SearchGuardRestFilter(backendRegistry, this.auditLog, threadPool, this.principalExtractor, this.settings);
        return components;
    }

    public Settings additionalSettings() {
        if (this.disabled) {
            return Settings.EMPTY;
        }
        Settings.Builder builder = Settings.builder();
        builder.put("transport.type", "com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyTransport");
        builder.put("http.type", "com.floragunn.searchguard.http.SearchGuardHttpServerTransport");
        return builder.build();
    }

    public List<Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.add(Setting.listSetting((String)"searchguard.authcz.admin_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"searchguard.config_index_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.groupSetting((String)"searchguard.authcz.impersonation_dn.", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"searchguard.audit.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.index", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.username", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"searchguard.audit.config.disabled_categories", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.intSetting((String)"searchguard.audit.threadpool.size", (int)10, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.audit.enable_request_details", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.audit.config.webhook.ssl.verify", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook.format", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.kerberos.krb5_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.kerberos.acceptor_keytab_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.kerberos.acceptor_principal", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"searchguard.audit.config.http_endpoints", (List)Lists.newArrayList((Object[])new String[]{"localhost:9200"}), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)"searchguard.audit.config.enable_ssl", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.audit.config.verify_hostnames", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.audit.config.enable_ssl_client_auth", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook_url", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.audit.config.webhook_format", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.cert.oid", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.cert.intercluster_request_evaluator_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"searchguard.nodes_dn", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)"searchguard.enable_snapshot_restore_privilege", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.check_snapshot_restore_write_privileges", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.clientauth_mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.enable_openssl_if_available", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.enabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.enable_openssl_if_available", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.enabled", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.enforce_hostname_verification", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.transport.resolve_hostname", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.keystore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_alias", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.truststore_type", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"searchguard.ssl.http.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"searchguard.ssl.http.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"searchguard.ssl.transport.enabled_ciphers", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.listSetting((String)"searchguard.ssl.transport.enabled_protocols", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.client.external_context_id", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.principal_extractor_class", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.transport.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemcert_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemkey_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemkey_password", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.pemtrustedcas_filepath", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.ssl.http.crl.file_path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.validate", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.prefer_crlfile_over_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.check_only_end_entities", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.disable_crldp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.boolSetting((String)"searchguard.ssl.http.crl.disable_ocsp", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.longSetting((String)"searchguard.ssl.http.crl.validation_date", (long)-1L, (long)-1L, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.listSetting((String)"searchguard.audit.ignore_users", Collections.emptyList(), Function.identity(), (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"node.client", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"node.local", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)"searchguard.disabled", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.intSetting((String)"searchguard.cache.ttl_minutes", (int)60, (int)0, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        settings.add(Setting.simpleString((String)"searchguard.tribe.clustername", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope, Setting.Property.Filtered}));
        return settings;
    }

    public List<String> getSettingsFilter() {
        ArrayList<String> settingsFilter = new ArrayList<String>();
        if (this.disabled) {
            return settingsFilter;
        }
        settingsFilter.add("searchguard.*");
        return settingsFilter;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        if (this.client || this.tribeNodeClient || this.disabled) {
            return Collections.emptyList();
        }
        ArrayList<Class<? extends LifecycleComponent>> services = new ArrayList<Class<? extends LifecycleComponent>>(1);
        services.add(GuiceHolder.class);
        return services;
    }

    public static class GuiceHolder
    implements LifecycleComponent {
        private static RepositoriesService repositoriesService;
        private static RemoteClusterService remoteClusterService;

        @Inject
        public GuiceHolder(RepositoriesService repositoriesService, TransportService remoteClusterService) {
            GuiceHolder.repositoriesService = repositoriesService;
            GuiceHolder.remoteClusterService = remoteClusterService.getRemoteClusterService();
        }

        public static RepositoriesService getRepositoriesService() {
            return repositoriesService;
        }

        public static RemoteClusterService getRemoteClusterService() {
            return remoteClusterService;
        }

        public void close() {
        }

        public Lifecycle.State lifecycleState() {
            return null;
        }

        public void addLifecycleListener(LifecycleListener listener) {
        }

        public void removeLifecycleListener(LifecycleListener listener) {
        }

        public void start() {
        }

        public void stop() {
        }
    }
}

