/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import org.apache.commons.lang.StringEscapeUtils;

public class DocumentBuilder {
    private static final String SEARCH_FIELDS = "{\"properties\":{\"title\":{\"type\":\"string\"},\"description\":{\"type\":\"string\"},\"hits\":{\"type\":\"integer\"},\"columns\":{\"type\":\"string\"},\"sort\":{\"type\":\"string\"},\"version\":{\"type\":\"integer\"},\"kibanaSavedObjectMeta\":{\"properties\":{\"searchSourceJSON\":{\"type\":\"string\"}}}}}";
    private StringBuffer contents = new StringBuffer();
    private boolean containsFields = false;

    public DocumentBuilder() {
        this.contents.append('{');
    }

    public DocumentBuilder title(String title) {
        return this.addField("title", title);
    }

    public DocumentBuilder description(String description) {
        return this.addField("description", description);
    }

    public DocumentBuilder version(int value) {
        return this.addField("version", value);
    }

    public DocumentBuilder timeFieldName(String name) {
        return this.addField("timeFieldName", name);
    }

    public DocumentBuilder intervalName(String name) {
        return this.addField("intervalName", name);
    }

    public DocumentBuilder searchProperty() {
        this.addComma();
        this.contents.append("\"properties\":");
        this.contents.append(StringEscapeUtils.escapeJava((String)SEARCH_FIELDS));
        if (!this.containsFields) {
            this.containsFields = true;
        }
        return this;
    }

    public DocumentBuilder defaultIndex(String index) {
        return this.addField("defaultIndex", index);
    }

    private DocumentBuilder addField(String key, int value) {
        this.addComma();
        this.contents.append('\"');
        this.contents.append(key);
        this.contents.append("\":");
        this.contents.append(value);
        if (!this.containsFields) {
            this.containsFields = true;
        }
        return this;
    }

    private DocumentBuilder addField(String key, String value) {
        this.addComma();
        this.contents.append('\"');
        this.contents.append(key);
        this.contents.append("\":\"");
        this.contents.append(value);
        this.contents.append('\"');
        if (!this.containsFields) {
            this.containsFields = true;
        }
        return this;
    }

    private void addComma() {
        if (this.containsFields) {
            this.contents.append(',');
        }
    }

    public String build() {
        this.contents.append('}');
        return this.contents.toString();
    }
}

