/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.kibana;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.model.Project;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.search.SearchHit;

public class KibanaUtils {
    private static final Logger LOGGER = Loggers.getLogger(KibanaUtils.class);
    private static final String INDICIES_TYPE = "index-pattern";
    public static final Project ALL_ALIAS = new Project(".all", null);
    private static final Project OPERATIONS = new Project(".operations", null);
    public static final Project EMPTY_PROJECT = new Project(".empty-project", null);
    private final PluginClient pluginClient;
    private String projectPrefix;
    private final Pattern reIndexPattern;

    public KibanaUtils(PluginSettings settings, PluginClient pluginClient) {
        this.pluginClient = pluginClient;
        this.projectPrefix = StringUtils.isNotBlank((String)settings.getCdmProjectPrefix()) ? settings.getCdmProjectPrefix() : "";
        this.reIndexPattern = Pattern.compile("^" + this.projectPrefix + "\\.(?<name>[a-zA-Z0-9-]*)\\.(?<uid>.*)\\.\\*$");
    }

    public Set<Project> getProjectsFromIndexPatterns(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        HashSet<Project> patterns = new HashSet<Project>();
        SearchResponse response = this.pluginClient.search(context.getKibanaIndex(), INDICIES_TYPE);
        if (response.getHits() != null && response.getHits().getTotalHits() > 0L) {
            for (SearchHit hit : response.getHits().getHits()) {
                String id = hit.getId();
                Project project = this.getProjectFromIndexPattern(id);
                if (project.getName().equals(id) && !project.equals(ALL_ALIAS)) continue;
                patterns.add(project);
            }
        } else {
            LOGGER.debug("No index-mappings found in the kibana index '{}'", (Object)context.getKibanaIndex());
        }
        return patterns;
    }

    public Project getProjectFromIndexPattern(String index) {
        if (StringUtils.isEmpty((String)index)) {
            return Project.EMPTY;
        }
        Matcher matcher = this.reIndexPattern.matcher(index);
        if (matcher.matches()) {
            return new Project(matcher.group("name"), matcher.group("uid"));
        }
        return new Project(index, null);
    }

    public String formatIndexPattern(Project project) {
        String uid;
        String prefix;
        String string = prefix = StringUtils.isNotEmpty((String)this.projectPrefix) ? this.projectPrefix + "." : "";
        if (project.equals(ALL_ALIAS)) {
            return ALL_ALIAS.getName();
        }
        String string2 = uid = project.getUID() != null ? "." + project.getUID() : "";
        if (project.equals(OPERATIONS)) {
            return project.getName() + ".*";
        }
        if (project.equals(EMPTY_PROJECT)) {
            return prefix + project.getName().substring(1) + ".*";
        }
        return String.format("%s%s%s.*", prefix, project.getName(), uid);
    }
}

