/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;

public class UserRolesMappingSyncStrategy
extends BaseRolesMappingSyncStrategy {
    public UserRolesMappingSyncStrategy(SearchGuardRolesMapping mapping, long expiresInMillis) {
        super(mapping, expiresInMillis);
    }

    @Override
    protected void syncFromImpl(OpenshiftRequestContextFactory.OpenshiftRequestContext context, RolesMappingBuilder builder) {
        String user = context.getUser();
        String kibanaRoleName = BaseRolesSyncStrategy.formatKibanaRoleName(context);
        builder.addUser(kibanaRoleName, user).expire(this.getExpires());
        if (context.isOperationsUser()) {
            builder.addUser("gen_project_operations", user).expire(this.getExpires());
        } else {
            String roleName = BaseRolesSyncStrategy.formatUserRoleName(user);
            builder.addUser(roleName, user).expire(this.getExpires());
        }
    }
}

