/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.configuration.ConfigurationChangeListener;
import com.floragunn.searchguard.http.RemoteIpDetector;
import java.net.InetSocketAddress;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.threadpool.ThreadPool;

public class XFFResolver
implements ConfigurationChangeListener {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile boolean enabled;
    private volatile RemoteIpDetector detector;
    private final ThreadContext threadContext;

    public XFFResolver(ThreadPool threadPool) {
        this.threadContext = threadPool.getThreadContext();
    }

    public TransportAddress resolve(RestRequest request) throws ElasticsearchSecurityException {
        if (this.log.isTraceEnabled()) {
            this.log.trace("resolve {}", (Object)request.getRemoteAddress());
        }
        if (this.enabled && request.getRemoteAddress() instanceof InetSocketAddress) {
            InetSocketAddress isa = new InetSocketAddress(this.detector.detect(request, this.threadContext), ((InetSocketAddress)request.getRemoteAddress()).getPort());
            if (isa.isUnresolved()) {
                throw new ElasticsearchSecurityException("Cannot resolve address " + isa.getHostString(), new Object[0]);
            }
            if (this.log.isTraceEnabled()) {
                if (this.threadContext.getTransient("_sg_xff_done") == Boolean.TRUE) {
                    this.log.trace("xff resolved {} to {}", (Object)request.getRemoteAddress(), (Object)isa);
                } else {
                    this.log.trace("no xff done for {}", request.getClass());
                }
            }
            return new InetSocketTransportAddress(isa);
        }
        if (request.getRemoteAddress() instanceof InetSocketAddress) {
            if (this.log.isTraceEnabled()) {
                this.log.trace("no xff done (enabled or no netty request) {},{},{},{}", (Object)this.enabled, request.getClass());
            }
            return new InetSocketTransportAddress((InetSocketAddress)request.getRemoteAddress());
        }
        throw new ElasticsearchSecurityException("Cannot handle this request. Remote address is " + request.getRemoteAddress() + " with request class " + request.getClass(), new Object[0]);
    }

    @Override
    public void onChange(Settings settings) {
        this.enabled = settings.getAsBoolean("searchguard.dynamic.http.xff.enabled", Boolean.valueOf(true));
        if (this.enabled) {
            this.detector = new RemoteIpDetector();
            this.detector.setInternalProxies(settings.get("searchguard.dynamic.http.xff.internalProxies", this.detector.getInternalProxies()));
            this.detector.setProxiesHeader(settings.get("searchguard.dynamic.http.xff.proxiesHeader", this.detector.getProxiesHeader()));
            this.detector.setRemoteIpHeader(settings.get("searchguard.dynamic.http.xff.remoteIpHeader", this.detector.getRemoteIpHeader()));
            this.detector.setTrustedProxies(settings.get("searchguard.dynamic.http.xff.trustedProxies", this.detector.getTrustedProxies()));
        } else {
            this.detector = null;
        }
    }
}

