/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class RolesBuilder {
    private Map<String, SearchGuardRoles.Roles> roles = new HashMap<String, SearchGuardRoles.Roles>();

    public Collection<SearchGuardRoles.Roles> build() {
        return this.roles.values();
    }

    public RolesBuilder addRole(SearchGuardRoles.Roles role) {
        this.roles.put(role.getName(), role);
        return this;
    }

    public RoleBuilder newRoleBuilder(String name) {
        return new RoleBuilder(name);
    }

    public static class RoleBuilder {
        private SearchGuardRoles.Roles role = new SearchGuardRoles.Roles();

        RoleBuilder(String name) {
            this.role.setName(name);
        }

        public RoleBuilder name(String name) {
            this.role.setName(name);
            return this;
        }

        public RoleBuilder expires(String expiresInMillies) {
            this.role.setExpires(expiresInMillies);
            return this;
        }

        public RoleBuilder addClusterAction(String action) {
            this.role.addClusterAction(action);
            return this;
        }

        public RoleBuilder setClusterActions(List<String> actions) {
            this.role.setCluster(actions);
            return this;
        }

        public RoleBuilder addIndexAction(SearchGuardRoles.Roles.Indices action) {
            this.role.addIndexAction(action);
            return this;
        }

        public RoleBuilder addIndexAction(String index, String type, String action) {
            this.role.addIndexAction(index, type, action);
            return this;
        }

        public RoleBuilder setIndicesActions(List<SearchGuardRoles.Roles.Indices> actions) {
            this.role.setIndices(actions);
            return this;
        }

        public SearchGuardRoles.Roles build() {
            return this.role;
        }
    }
}

