/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import com.floragunn.searchguard.action.configupdate.ConfigUpdateAction;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateRequest;
import com.floragunn.searchguard.action.configupdate.ConfigUpdateResponse;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.ConfigurationLoader;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardSyncStrategyFactory;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang.math.NumberUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.Action;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkRequestBuilder;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.support.WriteRequest;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.threadpool.ThreadPool;

public class ACLDocumentManager
implements ConfigurationSettings {
    private static final String[] CONFIG_DOCS = new String[]{"roles", "rolesmapping"};
    private static final Logger LOGGER = Loggers.getLogger(ACLDocumentManager.class);
    private final ReentrantLock lock = new ReentrantLock();
    private final String searchGuardIndex;
    private final PluginClient client;
    private final SearchGuardSyncStrategyFactory documentFactory;
    private final ConfigurationLoader configLoader;
    private final ThreadContext threadContext;

    public ACLDocumentManager(PluginClient client, PluginSettings settings, SearchGuardSyncStrategyFactory documentFactory, ThreadPool threadPool) {
        this.searchGuardIndex = settings.getSearchGuardIndex();
        this.client = client;
        this.documentFactory = documentFactory;
        this.threadContext = threadPool.getThreadContext();
        this.configLoader = new ConfigurationLoader(client.getClient(), threadPool, settings.getSettings());
    }

    private void logContent(String message, String type, ToXContent content) throws IOException {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message, (Object)type, (Object)XContentHelper.toString((ToXContent)content));
        }
    }

    private void logDebug(String message, Object obj) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(message, obj);
        }
    }

    public void expire() {
        this.syncAcl(new ExpireOperation(System.currentTimeMillis()));
    }

    public void syncAcl(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        if (!this.syncAcl(new SyncFromContextOperation(context))) {
            LOGGER.warn("Unable to sync ACLs for request from user: {}", (Object)context.getUser());
        }
    }

    private boolean syncAcl(ACLDocumentOperation operation) {
        for (int n : new int[]{1, 1, 2, 3, 5, 8}) {
            if (this.trySyncAcl(operation)) {
                return true;
            }
            try {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Sleeping for {}(s)", (Object)n);
                }
                Thread.sleep(n * 1000);
            }
            catch (InterruptedException e) {
                LOGGER.error("There was an error while trying the sleep the syncACL operation", (Throwable)e);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public boolean trySyncAcl(ACLDocumentOperation operation) {
        LOGGER.debug("Syncing the ACL to ElasticSearch");
        try {
            boolean bl;
            Throwable throwable;
            ThreadContext.StoredContext ctx;
            block24: {
                block25: {
                    Collection<SearchGuardACLDocument> docs;
                    block21: {
                        boolean bl2;
                        block22: {
                            block23: {
                                ctx = this.threadContext.stashContext();
                                throwable = null;
                                this.threadContext.putHeader("_sg_conf_request", "true");
                                this.lock.lock();
                                docs = this.loadAcls();
                                if (docs.size() >= 2) break block21;
                                bl2 = false;
                                if (ctx == null) break block22;
                                if (throwable == null) break block23;
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                                break block22;
                            }
                            ctx.close();
                        }
                        return bl2;
                    }
                    operation.execute(docs);
                    bl = this.isSuccessfulWrite(this.writeAcl(operation, docs));
                    if (ctx == null) break block24;
                    if (throwable == null) break block25;
                    try {
                        ctx.close();
                    }
                    catch (Throwable throwable3) {
                        throwable.addSuppressed(throwable3);
                    }
                    break block24;
                }
                ctx.close();
            }
            return bl;
            catch (Throwable throwable4) {
                try {
                    try {
                        throwable = throwable4;
                        throw throwable4;
                    }
                    catch (Throwable throwable5) {
                        if (ctx != null) {
                            if (throwable != null) {
                                try {
                                    ctx.close();
                                }
                                catch (Throwable throwable6) {
                                    throwable.addSuppressed(throwable6);
                                }
                            } else {
                                ctx.close();
                            }
                        }
                        throw throwable5;
                    }
                }
                catch (Exception e) {
                    LOGGER.error("Exception while syncing ACL to Elasticsearch", (Throwable)e);
                }
            }
        }
        finally {
            this.lock.unlock();
        }
        return false;
    }

    private Collection<SearchGuardACLDocument> loadAcls() throws Exception {
        LOGGER.debug("Loading SearchGuard ACL...waiting up to 30s");
        Map<String, Tuple<Settings, Long>> loadedDocs = this.configLoader.load(CONFIG_DOCS, 30L, TimeUnit.SECONDS);
        ArrayList<SearchGuardACLDocument> docs = new ArrayList<SearchGuardACLDocument>(loadedDocs.size());
        for (Map.Entry<String, Tuple<Settings, Long>> item : loadedDocs.entrySet()) {
            Settings settings = (Settings)item.getValue().v1();
            Long version = (Long)item.getValue().v2();
            Map original = settings.getAsStructuredMap();
            if (LOGGER.isDebugEnabled()) {
                this.logContent("Read in {}: {}", item.getKey(), (ToXContent)settings);
            }
            switch (item.getKey()) {
                case "roles": {
                    docs.add((SearchGuardACLDocument)new SearchGuardRoles(version).load(original));
                    break;
                }
                case "rolesmapping": {
                    docs.add((SearchGuardACLDocument)new SearchGuardRolesMapping(version).load(original));
                }
            }
        }
        return docs;
    }

    private BulkResponse writeAcl(ACLDocumentOperation operation, Collection<SearchGuardACLDocument> docs) throws Exception {
        BulkRequestBuilder builder = (BulkRequestBuilder)this.client.getClient().prepareBulk().setRefreshPolicy(WriteRequest.RefreshPolicy.WAIT_UNTIL);
        BulkRequest request = operation.buildRequest(this.client.getClient(), builder, docs);
        this.client.addCommonHeaders();
        return (BulkResponse)this.client.getClient().bulk(request).actionGet();
    }

    private boolean isSuccessfulWrite(BulkResponse response) {
        if (!response.hasFailures()) {
            ConfigUpdateRequest confRequest = new ConfigUpdateRequest(SEARCHGUARD_INITIAL_CONFIGS);
            this.client.addCommonHeaders();
            try {
                ConfigUpdateResponse cur = (ConfigUpdateResponse)this.client.getClient().execute((Action)ConfigUpdateAction.INSTANCE, (ActionRequest)confRequest).actionGet();
                int totNodes = cur.getNodes().size();
                if (totNodes > 0) {
                    LOGGER.debug("Successfully reloaded config with '{}' nodes", (Object)totNodes);
                } else {
                    LOGGER.warn("Failed to reloaded configs", (Object)totNodes);
                }
            }
            catch (Exception e) {
                LOGGER.error("Unable to notify of an ACL config update", (Throwable)e);
            }
            return true;
        }
        LOGGER.debug("Unable to write ACL {}", (Object)response.buildFailureMessage());
        return false;
    }

    class ExpireOperation
    implements ACLDocumentOperation {
        private long now;

        public ExpireOperation(long currentTimeMillis) {
            this.now = currentTimeMillis;
        }

        @Override
        public void execute(Collection<SearchGuardACLDocument> docs) {
            LOGGER.debug("Expiring ACLs older then {}", (Object)this.now);
            for (SearchGuardACLDocument doc : docs) {
                String expire;
                if ("rolesmapping".equals(doc.getType())) {
                    SearchGuardRolesMapping mappings = (SearchGuardRolesMapping)doc;
                    for (SearchGuardRolesMapping.RolesMapping mapping : mappings) {
                        expire = mapping.getExpire();
                        if (expire == null || !NumberUtils.isNumber((String)expire) || Long.parseLong(expire) >= this.now) continue;
                        ACLDocumentManager.this.logDebug("Expiring rolesMapping: {}", mapping);
                        mappings.removeRolesMapping(mapping);
                    }
                    continue;
                }
                if (!"roles".equals(doc.getType())) continue;
                SearchGuardRoles roles = (SearchGuardRoles)doc;
                for (SearchGuardRoles.Roles role : roles) {
                    expire = role.getExpire();
                    if (expire == null || Long.parseLong(expire) >= this.now) continue;
                    ACLDocumentManager.this.logDebug("Expiring role: {}", role);
                    roles.removeRole(role);
                }
            }
        }

        @Override
        public BulkRequest buildRequest(Client client, BulkRequestBuilder builder, Collection<SearchGuardACLDocument> docs) throws IOException {
            for (SearchGuardACLDocument doc : docs) {
                ACLDocumentManager.this.logContent("Expired doc {} to be: {}", doc.getType(), (ToXContent)doc);
                HashMap<String, BytesArray> content = new HashMap<String, BytesArray>();
                content.put(doc.getType(), new BytesArray(XContentHelper.toString((ToXContent)doc)));
                IndexRequestBuilder indexBuilder = client.prepareIndex(ACLDocumentManager.this.searchGuardIndex, doc.getType(), "0").setOpType(DocWriteRequest.OpType.INDEX).setSource(content);
                builder.add((IndexRequest)indexBuilder.request());
            }
            return (BulkRequest)builder.request();
        }
    }

    class SyncFromContextOperation
    implements ACLDocumentOperation {
        private OpenshiftRequestContextFactory.OpenshiftRequestContext context;

        public SyncFromContextOperation(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
            this.context = context;
        }

        @Override
        public void execute(Collection<SearchGuardACLDocument> docs) {
            LOGGER.debug("Syncing from context to ACL...");
            for (SearchGuardACLDocument doc : docs) {
                if ("rolesmapping".equals(doc.getType())) {
                    RolesMappingSyncStrategy rolesMappingSync = ACLDocumentManager.this.documentFactory.createRolesMappingSyncStrategy((SearchGuardRolesMapping)doc);
                    rolesMappingSync.syncFrom(this.context);
                    continue;
                }
                if (!"roles".equals(doc.getType())) continue;
                RolesSyncStrategy rolesSync = ACLDocumentManager.this.documentFactory.createRolesSyncStrategy((SearchGuardRoles)doc);
                rolesSync.syncFrom(this.context);
            }
        }

        @Override
        public BulkRequest buildRequest(Client client, BulkRequestBuilder builder, Collection<SearchGuardACLDocument> docs) throws IOException {
            for (SearchGuardACLDocument doc : docs) {
                ACLDocumentManager.this.logContent("Updating {} to: {}", doc.getType(), (ToXContent)doc);
                HashMap<String, BytesArray> content = new HashMap<String, BytesArray>();
                content.put(doc.getType(), new BytesArray(XContentHelper.toString((ToXContent)doc)));
                UpdateRequestBuilder update = client.prepareUpdate(ACLDocumentManager.this.searchGuardIndex, doc.getType(), "0").setDoc(content);
                if (doc.getVersion() != null) {
                    update.setVersion(doc.getVersion().longValue());
                }
                builder.add((UpdateRequest)update.request());
            }
            return (BulkRequest)builder.request();
        }
    }

    static interface ACLDocumentOperation {
        public void execute(Collection<SearchGuardACLDocument> var1);

        public BulkRequest buildRequest(Client var1, BulkRequestBuilder var2, Collection<SearchGuardACLDocument> var3) throws IOException;
    }
}

