/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.ssl.transport;

import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import io.netty.channel.Channel;
import io.netty.handler.ssl.SslHandler;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.DelegatingTransportChannel;
import org.elasticsearch.transport.TcpTransportChannel;
import org.elasticsearch.transport.TransportChannel;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;

public class SearchGuardSSLRequestHandler<T extends TransportRequest>
implements TransportRequestHandler<T> {
    private final String action;
    private final TransportRequestHandler<T> actualHandler;
    private final ThreadPool threadPool;
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrincipalExtractor principalExtractor;

    public SearchGuardSSLRequestHandler(String action, TransportRequestHandler<T> actualHandler, ThreadPool threadPool, PrincipalExtractor principalExtractor) {
        this.action = action;
        this.actualHandler = actualHandler;
        this.threadPool = threadPool;
        this.principalExtractor = principalExtractor;
    }

    protected ThreadContext getThreadContext() {
        if (this.threadPool == null) {
            return null;
        }
        return this.threadPool.getThreadContext();
    }

    public final void messageReceived(T request, TransportChannel channel) throws Exception {
        this.messageReceived(request, channel, null);
    }

    public final void messageReceived(T request, TransportChannel channel, Task task) throws Exception {
        ThreadContext threadContext = this.getThreadContext();
        if (SSLRequestHelper.containsBadHeader(threadContext, "_sg_ssl_")) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            channel.sendResponse((Exception)exception);
            throw exception;
        }
        if ("netty3".equals(channel.getChannelType()) || "netty4".equals(channel.getChannelType())) {
            ElasticsearchException exception = new ElasticsearchException(channel.getChannelType() + " not supported", new Object[0]);
            channel.sendResponse((Exception)exception);
            throw exception;
        }
        if (!"netty".equals(channel.getChannelType())) {
            this.messageReceivedDecorate(request, this.actualHandler, channel, task);
            return;
        }
        try {
            Channel nettyChannel = null;
            if (channel instanceof DelegatingTransportChannel) {
                nettyChannel = (Channel)((TcpTransportChannel)((DelegatingTransportChannel)channel).getChannel()).getChannel();
            } else if (channel instanceof TcpTransportChannel) {
                nettyChannel = (Channel)((TcpTransportChannel)channel).getChannel();
            } else {
                throw new Exception("Invalid channel of type " + channel.getClass());
            }
            SslHandler sslhandler = (SslHandler)nettyChannel.pipeline().get("ssl_server");
            if (sslhandler == null) {
                String msg = "No ssl handler found (SG 11)";
                ElasticsearchException exception = new ElasticsearchException("No ssl handler found (SG 11)", new Object[0]);
                channel.sendResponse((Exception)exception);
                throw exception;
            }
            Certificate[] peerCerts = sslhandler.engine().getSession().getPeerCertificates();
            Certificate[] localCerts = sslhandler.engine().getSession().getLocalCertificates();
            if (peerCerts != null && peerCerts.length > 0 && peerCerts[0] instanceof X509Certificate && localCerts != null && localCerts.length > 0 && localCerts[0] instanceof X509Certificate) {
                X509Certificate[] x509PeerCerts = (X509Certificate[])Arrays.copyOf(peerCerts, peerCerts.length, X509Certificate[].class);
                X509Certificate[] x509LocalCerts = (X509Certificate[])Arrays.copyOf(localCerts, localCerts.length, X509Certificate[].class);
                String principal = this.principalExtractor == null ? null : this.principalExtractor.extractPrincipal(x509PeerCerts[0], PrincipalExtractor.Type.TRANSPORT);
                this.addAdditionalContextValues(this.action, (TransportRequest)request, x509LocalCerts, x509PeerCerts, principal);
                this.addAdditionalContextValues(this.action, (TransportRequest)request, x509PeerCerts);
                if (threadContext != null) {
                    threadContext.putTransient("_sg_ssl_transport_principal", (Object)principal);
                    threadContext.putTransient("_sg_ssl_transport_peer_certificates", (Object)x509PeerCerts);
                    threadContext.putTransient("_sg_ssl_transport_local_certificates", (Object)x509LocalCerts);
                    threadContext.putTransient("_sg_ssl_transport_protocol", (Object)sslhandler.engine().getSession().getProtocol());
                    threadContext.putTransient("_sg_ssl_transport_cipher", (Object)sslhandler.engine().getSession().getCipherSuite());
                }
            } else {
                String msg = "No X509 transport client certificates found (SG 12)";
                ElasticsearchException exception = new ElasticsearchException("No X509 transport client certificates found (SG 12)", new Object[0]);
                this.errorThrown((Throwable)exception, (TransportRequest)request, this.action);
                channel.sendResponse((Exception)exception);
                throw exception;
            }
            this.messageReceivedDecorate(request, this.actualHandler, channel, task);
        }
        catch (SSLPeerUnverifiedException e) {
            this.errorThrown(e, (TransportRequest)request, this.action);
            ElasticsearchException exception = ExceptionsHelper.convertToElastic((Exception)e);
            channel.sendResponse((Exception)exception);
            throw exception;
        }
        catch (Exception e) {
            this.errorThrown(e, (TransportRequest)request, this.action);
            throw e;
        }
    }

    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] localCerts, X509Certificate[] peerCerts, String principal) throws Exception {
    }

    @Deprecated
    protected void addAdditionalContextValues(String action, TransportRequest request, X509Certificate[] peerCerts) throws Exception {
    }

    protected void messageReceivedDecorate(T request, TransportRequestHandler<T> actualHandler, TransportChannel transportChannel, Task task) throws Exception {
        actualHandler.messageReceived(request, transportChannel, task);
    }

    protected void errorThrown(Throwable t, TransportRequest request, String action) {
    }
}

