/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftAPIService;
import io.fabric8.elasticsearch.plugin.model.Project;
import io.fabric8.elasticsearch.util.RequestUtils;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.RestRequest;

public class OpenshiftRequestContextFactory {
    private static final Logger LOGGER = Loggers.getLogger(OpenshiftRequestContextFactory.class);
    private final OpenshiftAPIService apiService;
    private final RequestUtils utils;
    private final String[] operationsProjects;
    private final String kibanaPrefix;
    private String kibanaIndexMode;

    public OpenshiftRequestContextFactory(Settings settings, RequestUtils utils, OpenshiftAPIService apiService) {
        this.apiService = apiService;
        this.utils = utils;
        this.operationsProjects = settings.getAsArray("openshift.operations.project.names", ConfigurationSettings.DEFAULT_OPENSHIFT_OPS_PROJECTS);
        this.kibanaPrefix = settings.get("kibana.config_index_name", ".kibana");
        this.kibanaIndexMode = settings.get("openshift.kibana.index.mode", "unique");
        if (!ArrayUtils.contains((Object[])new String[]{"unique", "shared_ops", "shared_non_ops"}, (Object)this.kibanaIndexMode.toLowerCase())) {
            this.kibanaIndexMode = "unique";
        }
        LOGGER.info("Using kibanaIndexMode: '{}'", (Object)this.kibanaIndexMode);
    }

    public OpenshiftRequestContext create(RestRequest request) throws Exception {
        this.logRequest(request);
        HashSet<Project> projects = new HashSet();
        boolean isClusterAdmin = false;
        String user = this.utils.getUser(request);
        String token = this.utils.getBearerToken(request);
        if (StringUtils.isNotBlank((String)token)) {
            user = this.utils.assertUser(request);
            isClusterAdmin = this.utils.isOperationsUser(request);
            if (user.contains("\\")) {
                user = user.replace("\\", "/");
            }
            projects = this.listProjectsFor(user, token);
            return new OpenshiftRequestContext(user, token, isClusterAdmin, projects, this.getKibanaIndex(user, isClusterAdmin), this.kibanaIndexMode);
        }
        LOGGER.debug("Returning EMPTY request context; either was provided client cert or empty token.");
        return OpenshiftRequestContext.EMPTY;
    }

    private void logRequest(RestRequest request) {
        if (LOGGER.isDebugEnabled()) {
            String user = this.utils.getUser(request);
            String token = this.utils.getBearerToken(request);
            LOGGER.debug("Handling Request... {}", (Object)request.uri());
            if (LOGGER.isTraceEnabled()) {
                ArrayList<String> headers = new ArrayList<String>();
                for (Map.Entry entry : request.getHeaders().entrySet()) {
                    if ("authorization".equals(((String)entry.getKey()).toLowerCase())) {
                        headers.add((String)entry.getKey() + "=Bearer <REDACTED>");
                        continue;
                    }
                    headers.add((String)entry.getKey() + "=" + entry.getValue());
                }
                LOGGER.trace("Request headers: {}", headers);
            }
            LOGGER.debug("Evaluating request for user '{}' with a {} token", (Object)user, (Object)(StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"));
        }
    }

    private Set<Project> listProjectsFor(String user, final String token) throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(new PrivilegedAction<Set<Project>>(){

            @Override
            public Set<Project> run() {
                Set<Project> projects = OpenshiftRequestContextFactory.this.apiService.projectNames(token);
                Iterator<Project> it = projects.iterator();
                while (it.hasNext()) {
                    if (!OpenshiftRequestContextFactory.this.isBlacklistProject(it.next().getName())) continue;
                    it.remove();
                }
                return projects;
            }
        });
    }

    private boolean isBlacklistProject(String project) {
        return ArrayUtils.contains((Object[])this.operationsProjects, (Object)project.toLowerCase());
    }

    private String getKibanaIndex(String username, boolean isOpsUser) {
        return OpenshiftRequestContextFactory.getKibanaIndex(this.kibanaPrefix, this.kibanaIndexMode, username, isOpsUser);
    }

    public static String getKibanaIndex(String kibanaPrefix, String kibanaIndexMode, String username, boolean isOpsUser) {
        if (StringUtils.isBlank((String)username)) {
            return "";
        }
        if (("shared_ops".equals(kibanaIndexMode) || "shared_non_ops".equals(kibanaIndexMode)) && isOpsUser) {
            return kibanaPrefix;
        }
        if ("shared_non_ops".equals(kibanaIndexMode)) {
            return kibanaPrefix + "_non_ops";
        }
        return kibanaPrefix + "." + OpenshiftRequestContextFactory.getUsernameHash(username);
    }

    public static String getUsernameHash(String username) {
        return DigestUtils.sha1Hex((String)username);
    }

    public static class OpenshiftRequestContext {
        public static final OpenshiftRequestContext EMPTY = new OpenshiftRequestContext("", "", false, new HashSet<Project>(), "", "");
        private final String user;
        private final String token;
        private final boolean isClusterAdmin;
        private final Set<Project> projects;
        private final String kibanaIndex;
        private final String kibanaIndexMode;

        public OpenshiftRequestContext(String user, String token, boolean isClusterAdmin, Set<Project> projects, String kibanaIndex, String kibanaIndexMode) {
            this.user = user;
            this.token = token;
            this.isClusterAdmin = isClusterAdmin;
            this.projects = new HashSet<Project>(projects);
            this.kibanaIndex = kibanaIndex;
            this.kibanaIndexMode = kibanaIndexMode;
        }

        public boolean isAuthenticated() {
            return StringUtils.isNotEmpty((String)this.token) && StringUtils.isNotEmpty((String)this.user);
        }

        public String getUser() {
            return this.user;
        }

        public String getToken() {
            return this.token;
        }

        public boolean isOperationsUser() {
            return this.isClusterAdmin;
        }

        public Set<Project> getProjects() {
            return this.projects;
        }

        public String getKibanaIndex() {
            return this.kibanaIndex;
        }

        public String getKibanaIndexMode() {
            return this.kibanaIndexMode;
        }
    }
}

