/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.rest;

import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.TransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class KibanaInfoAction
extends BaseRestHandler {
    private final PrivilegesEvaluator evaluator;
    private final ThreadContext threadContext;

    public KibanaInfoAction(Settings settings, RestController controller, PrivilegesEvaluator evaluator, ThreadPool threadPool) {
        super(settings);
        this.threadContext = threadPool.getThreadContext();
        this.evaluator = evaluator;
        controller.registerHandler(RestRequest.Method.GET, "/_searchguard/kibanainfo", (RestHandler)this);
        controller.registerHandler(RestRequest.Method.POST, "/_searchguard/kibanainfo", (RestHandler)this);
    }

    protected BaseRestHandler.RestChannelConsumer prepareRequest(RestRequest request, NodeClient client) throws IOException {
        return new BaseRestHandler.RestChannelConsumer(){

            public void accept(RestChannel channel) throws Exception {
                XContentBuilder builder = channel.newBuilder();
                BytesRestResponse response = null;
                try {
                    User user = (User)KibanaInfoAction.this.threadContext.getTransient("_sg_user");
                    TransportAddress remoteAddress = (TransportAddress)KibanaInfoAction.this.threadContext.getTransient("_sg_remote_address");
                    builder.startObject();
                    builder.field("user_name", user == null ? null : user.getName());
                    builder.field("not_fail_on_forbidden_enabled", KibanaInfoAction.this.evaluator.notFailOnForbiddenEnabled());
                    builder.field("kibana_mt_enabled", KibanaInfoAction.this.evaluator.multitenancyEnabled());
                    builder.field("kibana_index", KibanaInfoAction.this.evaluator.kibanaIndex());
                    builder.field("kibana_server_user", KibanaInfoAction.this.evaluator.kibanaServerUsername());
                    builder.field("kibana_index_readonly", KibanaInfoAction.this.evaluator.kibanaIndexReadonly(user, remoteAddress));
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.OK, builder);
                }
                catch (Exception e1) {
                    builder = channel.newBuilder();
                    builder.startObject();
                    builder.field("error", e1.toString());
                    builder.endObject();
                    response = new BytesRestResponse(RestStatus.INTERNAL_SERVER_ERROR, builder);
                }
                channel.sendResponse((RestResponse)response);
            }
        };
    }
}

