/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.ProjectRolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.ProjectRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;
import io.fabric8.elasticsearch.plugin.acl.UserRolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.UserRolesSyncStrategy;

public class SearchGuardSyncStrategyFactory {
    public static final String PROJECT = "project";
    public static final String USER = "user";
    private final PluginSettings settings;

    public SearchGuardSyncStrategyFactory(PluginSettings settings) {
        this.settings = settings;
    }

    public RolesMappingSyncStrategy createRolesMappingSyncStrategy(SearchGuardRolesMapping mapping) {
        long expires = System.currentTimeMillis() + this.settings.getACLExpiresInMillis();
        if (PROJECT.equals(this.settings.getRoleStrategy())) {
            return new ProjectRolesMappingSyncStrategy(mapping, expires);
        }
        return new UserRolesMappingSyncStrategy(mapping, expires);
    }

    public RolesSyncStrategy createRolesSyncStrategy(SearchGuardRoles roles) {
        long expires = System.currentTimeMillis() + this.settings.getACLExpiresInMillis();
        if (PROJECT.equals(this.settings.getRoleStrategy())) {
            return new ProjectRolesSyncStrategy(roles, this.settings.getDefaultKibanaIndex(), this.settings.getCdmProjectPrefix(), this.settings.getKibanaIndexMode(), expires);
        }
        return new UserRolesSyncStrategy(roles, this.settings.getDefaultKibanaIndex(), this.settings.getCdmProjectPrefix(), this.settings.getKibanaIndexMode(), expires);
    }
}

