/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import com.jayway.jsonpath.JsonPath;
import com.jayway.jsonpath.Predicate;
import io.fabric8.elasticsearch.plugin.model.Project;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.kubernetes.client.KubernetesClientException;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import java.io.IOException;
import java.io.InputStream;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import okhttp3.MediaType;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.rest.RestStatus;

public class OpenshiftAPIService {
    private static final String ACCEPT = "Accept";
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";
    private static final Logger LOGGER = Loggers.getLogger(OpenshiftAPIService.class);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String userName(String token) {
        Response response = null;
        try (DefaultOpenShiftClient client = this.buildClient(token);){
            Request okRequest = new Request.Builder().url(client.getMasterUrl() + "apis/user.openshift.io/v1/users/~").header(ACCEPT, APPLICATION_JSON).build();
            response = client.getHttpClient().newCall(okRequest).execute();
            String body = response.body().string();
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Response: code '{}' {}", (Object)response.code(), (Object)body);
            }
            if (response.code() != RestStatus.OK.getStatus()) {
                throw new ElasticsearchSecurityException("Unable to determine username from the token provided", RestStatus.fromCode((int)response.code()), new Object[0]);
            }
            String string = (String)JsonPath.read((String)body, (String)"$.metadata.name", (Predicate[])new Predicate[0]);
            return string;
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving username from token", (Throwable)e);
            throw new ElasticsearchException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Set<Project> projectNames(String token) {
        try (DefaultOpenShiftClient client = this.buildClient(token);){
            Request request = new Request.Builder().url(client.getMasterUrl() + "apis/project.openshift.io/v1/projects").header(ACCEPT, APPLICATION_JSON).build();
            Response response = client.getHttpClient().newCall(request).execute();
            if (response.code() != RestStatus.OK.getStatus()) {
                throw new ElasticsearchSecurityException("Unable to retrieve users's project list", RestStatus.fromCode((int)response.code()), new Object[0]);
            }
            HashSet<Project> projects = new HashSet<Project>();
            List raw = (List)JsonPath.read((InputStream)response.body().byteStream(), (String)"$.items[*].metadata", (Predicate[])new Predicate[0]);
            for (Map map : raw) {
                projects.add(new Project((String)map.get("name"), (String)map.get("uid")));
            }
            HashSet<Project> hashSet = projects;
            return hashSet;
        }
        catch (KubernetesClientException e) {
            LOGGER.error("Error retrieving project list", (Throwable)e);
            throw new ElasticsearchSecurityException(e.getMessage(), new Object[0]);
        }
        catch (IOException e) {
            LOGGER.error("Error retrieving project list", (Throwable)e);
            throw new ElasticsearchException((Throwable)e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean localSubjectAccessReview(String token, String project, String verb, String resource, String resourceAPIGroup, String[] scopes) {
        try (DefaultOpenShiftClient client = this.buildClient(token);){
            XContentBuilder payload = XContentFactory.jsonBuilder().startObject().field("kind", "LocalSubjectAccessReview").field("apiVersion", "authorization.openshift.io/v1").field("verb", verb).field("resourceAPIGroup", resourceAPIGroup).field("resource", resource).field("namespace", project).array("scopes", scopes).endObject();
            Request request = new Request.Builder().url(String.format("%sapis/authorization.openshift.io/v1/namespaces/%s/localsubjectaccessreviews", client.getMasterUrl(), project)).header(CONTENT_TYPE, APPLICATION_JSON).header(ACCEPT, APPLICATION_JSON).post(RequestBody.create((MediaType)MediaType.parse((String)APPLICATION_JSON), (String)payload.string())).build();
            Response response = client.getHttpClient().newCall(request).execute();
            if (response.code() != RestStatus.CREATED.getStatus()) {
                throw new ElasticsearchSecurityException("Unable to determine user's operations role", RestStatus.fromCode((int)response.code()), new Object[0]);
            }
            boolean bl = (Boolean)JsonPath.read((InputStream)response.body().byteStream(), (String)"$.allowed", (Predicate[])new Predicate[0]);
            return bl;
        }
        catch (IOException e) {
            LOGGER.error("Error determining user's role", (Throwable)e);
            return false;
        }
    }

    private DefaultOpenShiftClient buildClient(String token) {
        Config config = ((ConfigBuilder)new ConfigBuilder().withOauthToken(token)).build();
        return new DefaultOpenShiftClient(config);
    }
}

