/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.user.AuthCredentials;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public class HTTPProxyAuthenticator
implements HTTPAuthenticator {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private volatile Settings settings;

    public HTTPProxyAuthenticator(Settings settings) {
        this.settings = settings;
    }

    @Override
    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) {
        if (context.getTransient("_sg_xff_done") != Boolean.TRUE) {
            throw new ElasticsearchSecurityException("xff not done", new Object[0]);
        }
        String userHeader = this.settings.get("user_header");
        String rolesHeader = this.settings.get("roles_header");
        this.log.debug("headers {}", (Object)request.getHeaders());
        this.log.debug("userHeader {}, value {}", (Object)userHeader, userHeader == null ? null : request.header(userHeader));
        this.log.debug("rolesHeader {}, value {}", (Object)rolesHeader, rolesHeader == null ? null : request.header(rolesHeader));
        if (!Strings.isNullOrEmpty((String)userHeader) && !Strings.isNullOrEmpty((String)request.header(userHeader))) {
            String[] backendRoles = null;
            if (!Strings.isNullOrEmpty((String)rolesHeader) && !Strings.isNullOrEmpty((String)request.header(rolesHeader))) {
                backendRoles = request.header(rolesHeader).split(",");
            }
            return new AuthCredentials(request.header(userHeader), backendRoles).markComplete();
        }
        this.log.trace("No '{}' header, send 401", (Object)userHeader);
        return null;
    }

    @Override
    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials creds) {
        return false;
    }

    @Override
    public String getType() {
        return "proxy";
    }
}

