/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.DlsFlsRequestValve;
import com.floragunn.searchguard.configuration.PrivilegesEvaluator;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import java.util.Objects;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.tasks.Task;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequest;

public class SearchGuardFilter
implements ActionFilter {
    protected final Logger log = LogManager.getLogger(this.getClass());
    private final PrivilegesEvaluator evalp;
    private final Settings settings;
    private final AdminDNs adminDns;
    private DlsFlsRequestValve dlsFlsValve;
    private final AuditLog auditLog;
    private final ThreadContext threadContext;

    public SearchGuardFilter(Settings settings, PrivilegesEvaluator evalp, AdminDNs adminDns, DlsFlsRequestValve dlsFlsValve, AuditLog auditLog, ThreadPool threadPool) {
        this.settings = settings;
        this.evalp = evalp;
        this.adminDns = adminDns;
        this.dlsFlsValve = dlsFlsValve;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
    }

    public int order() {
        return Integer.MIN_VALUE;
    }

    public void apply(Task task, String action, ActionRequest request, ActionListener listener, ActionFilterChain chain) {
        try {
            PrivilegesEvaluator.PrivEvalResponse pres;
            User user = (User)this.threadContext.getTransient("_sg_user");
            if (user == null || user.equals(User.SG_INTERNAL) && (HeaderHelper.isDirectRequest(this.threadContext) || HeaderHelper.isInterClusterRequest(this.threadContext))) {
                chain.proceed(task, action, request, listener);
                return;
            }
            boolean userIsAdmin = SearchGuardFilter.isUserAdmin(Objects.requireNonNull(user), this.adminDns);
            boolean interClusterRequest = !action.contains("[") && HeaderHelper.isInterClusterRequest(this.threadContext);
            boolean conRequest = "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_sg_conf_request"));
            if (userIsAdmin || interClusterRequest || conRequest) {
                if (userIsAdmin && !interClusterRequest && !conRequest) {
                    this.auditLog.logAuthenticatedRequest((TransportRequest)request, action);
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (action.startsWith("internal:gateway/local/started_shards") || action.startsWith("internal:cluster/nodes/indices/shard/store")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("Allow " + action + " always");
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            if (User.SG_INTERNAL.equals(user) && HeaderHelper.isTrustedClusterRequest(this.threadContext) && action.startsWith("cluster:monitor/")) {
                if (this.log.isTraceEnabled()) {
                    this.log.trace("No cross cluster search user, will allow only standard discovery and monitoring actions");
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            PrivilegesEvaluator eval = this.evalp;
            if (!eval.isInitialized()) {
                this.log.error("Search Guard not initialized (SG11) for {}", (Object)action);
                listener.onFailure((Exception)new ElasticsearchSecurityException("Search Guard not initialized (SG11) for " + action + ". See https://github.com/floragunncom/search-guard-docs/blob/master/sgadmin.md", RestStatus.SERVICE_UNAVAILABLE, new Object[0]));
                return;
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("Evaluate permissions for user: {}", (Object)user.getName());
            }
            if ((pres = eval.evaluate(user, action, request)).isAllowed()) {
                this.auditLog.logAuthenticatedRequest((TransportRequest)request, action);
                if (!this.dlsFlsValve.invoke(request, listener, pres.getAllowedFlsFields(), pres.getQueries())) {
                    return;
                }
                chain.proceed(task, action, request, listener);
                return;
            }
            this.auditLog.logMissingPrivileges(action, (TransportRequest)request);
            this.log.debug("no permissions for {}", pres.getMissingPrivileges());
            listener.onFailure((Exception)new ElasticsearchSecurityException("no permissions for " + pres.getMissingPrivileges() + " and " + user, RestStatus.FORBIDDEN, new Object[0]));
            return;
        }
        catch (Throwable e) {
            this.log.error("Unexpected exception " + e, e);
            listener.onFailure((Exception)new ElasticsearchSecurityException("Unexpected exception " + action, RestStatus.INTERNAL_SERVER_ERROR, new Object[0]));
            return;
        }
    }

    private static boolean isUserAdmin(User user, AdminDNs adminDns) {
        if (user != null) {
            if (AdminDNs.isAdmin(user.getName())) {
                return true;
            }
        }
        return false;
    }
}

