/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.util;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftAPIService;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.TreeMap;
import org.apache.commons.lang.ArrayUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public class RequestUtils
implements ConfigurationSettings {
    private static final Logger LOGGER = Loggers.getLogger(RequestUtils.class);
    public static final String AUTHORIZATION_HEADER = "authorization";
    public static final String X_FORWARDED_ACCESS_TOKEN = "x-forwarded-access-token";
    private final String proxyUserHeader;
    private final String defaultKibanaIndex;
    private final OpenshiftAPIService apiService;

    public RequestUtils(PluginSettings pluginSettings, OpenshiftAPIService apiService) {
        this.defaultKibanaIndex = pluginSettings.getDefaultKibanaIndex();
        this.proxyUserHeader = pluginSettings.getSettings().get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.apiService = apiService;
    }

    public boolean hasUserHeader(RestRequest request) {
        return StringUtils.isNotEmpty((String)this.getUser(request));
    }

    public String getUser(RestRequest request) {
        return StringUtils.defaultIfEmpty((String)request.header(this.proxyUserHeader), (String)"");
    }

    public String getBearerToken(RestRequest request) {
        String[] auth;
        String token = request.header(X_FORWARDED_ACCESS_TOKEN);
        if (token == null && request.header(AUTHORIZATION_HEADER) != null && (auth = StringUtils.defaultIfEmpty((String)request.header(AUTHORIZATION_HEADER), (String)"").split(" ")).length >= 2 && "Bearer".equals(auth[0])) {
            token = auth[1];
        }
        return StringUtils.defaultIfEmpty((String)token, (String)"");
    }

    public boolean isClientCertAuth(ThreadContext threadContext) {
        return threadContext != null && StringUtils.isNotEmpty((String)((String)threadContext.getTransient("_sg_ssl_transport_principal")));
    }

    public boolean isOperationsUser(final RestRequest request) {
        return this.executePrivilegedAction(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                String user = StringUtils.defaultIfEmpty((String)RequestUtils.this.getUser(request), (String)"<UNKNOWN>");
                String token = RequestUtils.this.getBearerToken(request);
                boolean allowed = false;
                try {
                    allowed = RequestUtils.this.apiService.localSubjectAccessReview(token, "default", "view", "pods/log", "", ArrayUtils.EMPTY_STRING_ARRAY);
                }
                catch (Exception e) {
                    LOGGER.error("Exception determining user's '{}' role: {}", (Object)user, (Object)e);
                }
                finally {
                    LOGGER.debug("User '{}' isOperationsUser: {}", (Object)user, (Object)allowed);
                }
                return allowed;
            }
        });
    }

    private <T> T executePrivilegedAction(PrivilegedAction<T> action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(action);
    }

    public String assertUser(final RestRequest request) {
        return this.executePrivilegedAction(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String token = RequestUtils.this.getBearerToken(request);
                return RequestUtils.this.apiService.userName(token);
            }
        });
    }

    public RestRequest modifyRequest(final RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context, final RestChannel channel) {
        final String uri = this.getUri(request, context);
        final BytesReference content = this.getContent(request, context);
        if (!this.getUser(request).equals(context.getUser()) || !uri.equals(request.uri()) || content != request.content()) {
            LOGGER.debug("Modifying header '{}' to be '{}'", (Object)this.proxyUserHeader, (Object)context.getUser());
            TreeMap<String, List<String>> modifiedHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            modifiedHeaders.putAll(request.getHeaders());
            modifiedHeaders.put(this.proxyUserHeader, Arrays.asList(context.getUser()));
            if (request.header("Content-Type") != null && request.header("Content-Type").toLowerCase().endsWith("json")) {
                modifiedHeaders.put("Content-Type", Arrays.asList("application/json"));
            }
            RestRequest modified = new RestRequest(request.getXContentRegistry(), uri, modifiedHeaders){

                public RestRequest.Method method() {
                    return request.method();
                }

                public String uri() {
                    return uri;
                }

                public boolean hasContent() {
                    return content.length() > 0;
                }

                public BytesReference content() {
                    return content;
                }

                public SocketAddress getRemoteAddress() {
                    return request.getRemoteAddress();
                }

                public SocketAddress getLocalAddress() {
                    return request.getRemoteAddress();
                }

                public Channel getChannel() {
                    return (Channel)channel;
                }
            };
            modified.params().putAll(request.params());
            if (uri.contains(this.defaultKibanaIndex)) {
                modified.params().put("index", context.getKibanaIndex());
            }
            return modified;
        }
        return request;
    }

    private BytesReference getContent(RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        String content = request.content().utf8ToString();
        if (OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY != context && content.contains("_index\":\"" + this.defaultKibanaIndex)) {
            LOGGER.debug("Replacing the content that references the default kibana index");
            String replaced = content.replaceAll("_index\":\"" + this.defaultKibanaIndex + "\"", "_index\":\"" + context.getKibanaIndex() + "\"");
            return new BytesArray(replaced);
        }
        return request.content();
    }

    private String getUri(RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        if (OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY != context && request.uri().contains(this.defaultKibanaIndex) && !context.getKibanaIndex().equals(this.defaultKibanaIndex)) {
            String uri = request.uri().replaceAll(this.defaultKibanaIndex, context.getKibanaIndex());
            LOGGER.debug("Modifying uri to be '{}'", (Object)uri);
            return uri;
        }
        return request.uri();
    }
}

