/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.transport;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.support.Base64Helper;
import com.floragunn.searchguard.transport.InterClusterRequestEvaluator;
import com.floragunn.searchguard.transport.SearchGuardRequestHandler;
import com.floragunn.searchguard.user.User;
import com.google.common.collect.Maps;
import java.net.InetSocketAddress;
import java.util.Map;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportException;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.transport.TransportRequest;
import org.elasticsearch.transport.TransportRequestHandler;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportResponse;
import org.elasticsearch.transport.TransportResponseHandler;

public class SearchGuardInterceptor {
    private BackendRegistry backendRegistry;
    private AuditLog auditLog;
    private final ThreadPool threadPool;
    private final PrincipalExtractor principalExtractor;
    private final InterClusterRequestEvaluator requestEvalProvider;
    private final ClusterService cs;
    private final Settings settings;

    public SearchGuardInterceptor(Settings settings, ThreadPool threadPool, BackendRegistry backendRegistry, AuditLog auditLog, PrincipalExtractor principalExtractor, InterClusterRequestEvaluator requestEvalProvider, ClusterService cs) {
        this.backendRegistry = backendRegistry;
        this.auditLog = auditLog;
        this.threadPool = threadPool;
        this.principalExtractor = principalExtractor;
        this.requestEvalProvider = requestEvalProvider;
        this.cs = cs;
        this.settings = settings;
    }

    public <T extends TransportRequest> SearchGuardRequestHandler<T> getHandler(String action, TransportRequestHandler<T> actualHandler) {
        return new SearchGuardRequestHandler<T>(action, actualHandler, this.threadPool, this.backendRegistry, this.auditLog, this.principalExtractor, this.requestEvalProvider, this.cs);
    }

    public <T extends TransportResponse> void sendRequestDecorate(TransportInterceptor.AsyncSender sender, Transport.Connection connection, String action, TransportRequest request, TransportRequestOptions options, TransportResponseHandler<T> handler) {
        Map origHeaders0 = this.getThreadContext().getHeaders();
        User user0 = (User)this.getThreadContext().getTransient("_sg_user");
        Object remoteAdress0 = this.getThreadContext().getTransient("_sg_remote_address");
        try (ThreadContext.StoredContext stashedContext = this.getThreadContext().stashContext();){
            RestoringTransportResponseHandler restoringHandler = new RestoringTransportResponseHandler(handler, stashedContext);
            this.getThreadContext().putHeader("_sg_remotecn", this.settings.get("searchguard.tribe.clustername", this.cs.getClusterName().value()));
            if (this.settings.getAsBoolean("action.master.force_local", Boolean.valueOf(false)).booleanValue() && this.settings.getByPrefix("tribe").getAsMap().size() > 0) {
                this.getThreadContext().putHeader("_sg_header_tn", "true");
            }
            this.getThreadContext().putHeader(Maps.filterKeys((Map)origHeaders0, k -> k != null && (k.equals("_sg_conf_request") || k.equals("_sg_remote_address_header") || k.equals("_sg_user_header") || k.equals("_sg_dls_query") || k.equals("_sg_fls_fields"))));
            this.ensureCorrectHeaders(action, remoteAdress0, user0);
            sender.sendRequest(connection, action, request, options, restoringHandler);
        }
    }

    private void ensureCorrectHeaders(String action, Object remoteAdr, User origUser) {
        if (remoteAdr != null && remoteAdr instanceof InetSocketTransportAddress) {
            String remoteAddressHeader = this.getThreadContext().getHeader("_sg_remote_address_header");
            if (remoteAddressHeader == null) {
                this.getThreadContext().putHeader("_sg_remote_address_header", Base64Helper.serializeObject(((InetSocketTransportAddress)remoteAdr).address()));
            } else if (!((InetSocketAddress)Base64Helper.deserializeObject(remoteAddressHeader)).equals(((InetSocketTransportAddress)remoteAdr).address())) {
                throw new RuntimeException("remote address mismatch " + Base64Helper.deserializeObject(remoteAddressHeader) + "!=" + ((InetSocketTransportAddress)remoteAdr).address());
            }
        }
        if (origUser != null) {
            String userHeader = this.getThreadContext().getHeader("_sg_user_header");
            if (userHeader == null) {
                this.getThreadContext().putHeader("_sg_user_header", Base64Helper.serializeObject(origUser));
            } else if (!((User)Base64Helper.deserializeObject(userHeader)).getName().equals(origUser.getName())) {
                throw new RuntimeException("user mismatch " + Base64Helper.deserializeObject(userHeader) + "!=" + origUser);
            }
        }
    }

    private ThreadContext getThreadContext() {
        return this.threadPool.getThreadContext();
    }

    private static class RestoringTransportResponseHandler<T extends TransportResponse>
    implements TransportResponseHandler<T> {
        private final ThreadContext.StoredContext contextToRestore;
        private final TransportResponseHandler<T> innerHandler;

        private RestoringTransportResponseHandler(TransportResponseHandler<T> innerHandler, ThreadContext.StoredContext contextToRestore) {
            this.contextToRestore = contextToRestore;
            this.innerHandler = innerHandler;
        }

        public T newInstance() {
            return (T)this.innerHandler.newInstance();
        }

        public void handleResponse(T response) {
            this.contextToRestore.restore();
            this.innerHandler.handleResponse(response);
        }

        public void handleException(TransportException e) {
            this.contextToRestore.restore();
            this.innerHandler.handleException(e);
        }

        public String executor() {
            return this.innerHandler.executor();
        }
    }
}

