/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.filter;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.auth.BackendRegistry;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.ssl.util.ExceptionUtils;
import com.floragunn.searchguard.ssl.util.SSLRequestHelper;
import com.floragunn.searchguard.support.HTTPHelper;
import javax.net.ssl.SSLPeerUnverifiedException;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class SearchGuardRestFilter {
    private final BackendRegistry registry;
    private final AuditLog auditLog;
    private final ThreadContext threadContext;
    private final PrincipalExtractor principalExtractor;
    private final Settings settings;

    public SearchGuardRestFilter(BackendRegistry registry, AuditLog auditLog, ThreadPool threadPool, PrincipalExtractor principalExtractor, Settings settings) {
        this.registry = registry;
        this.auditLog = auditLog;
        this.threadContext = threadPool.getThreadContext();
        this.principalExtractor = principalExtractor;
        this.settings = settings;
    }

    public RestHandler wrap(final RestHandler original) {
        return new RestHandler(){

            public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                if (!SearchGuardRestFilter.this.checkAndAuthenticateRequest(request, channel, client)) {
                    original.handleRequest(request, channel, client);
                }
            }
        };
    }

    private boolean checkAndAuthenticateRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        if (HTTPHelper.containsBadHeader(request)) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        if (SSLRequestHelper.containsBadHeader((ThreadContext)this.threadContext, (String)"_sg_")) {
            ElasticsearchException exception = ExceptionUtils.createBadHeaderException();
            this.auditLog.logBadHeaders(request);
            channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Exception)exception));
            return true;
        }
        try {
            SSLRequestHelper.SSLInfo sslInfo = SSLRequestHelper.getSSLInfo((Settings)this.settings, (RestRequest)request, (PrincipalExtractor)this.principalExtractor);
            if (sslInfo != null) {
                if (sslInfo.getPrincipal() != null) {
                    this.threadContext.putTransient("_sg_ssl_principal", (Object)sslInfo.getPrincipal());
                }
                if (sslInfo.getX509Certs() != null) {
                    this.threadContext.putTransient("_sg_ssl_peer_certificates", (Object)sslInfo.getX509Certs());
                }
                this.threadContext.putTransient("_sg_ssl_protocol", (Object)sslInfo.getProtocol());
                this.threadContext.putTransient("_sg_ssl_cipher", (Object)sslInfo.getCipher());
            }
        }
        catch (SSLPeerUnverifiedException e) {
            throw ExceptionsHelper.convertToElastic((Exception)e);
        }
        return request.method() != RestRequest.Method.OPTIONS && !this.registry.authenticate(request, channel, this.threadContext);
    }
}

