/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.RoleBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang.ObjectUtils;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class SearchGuardRoles
implements Iterable<Roles>,
ConfigurationSettings,
SearchGuardACLDocument<SearchGuardRoles> {
    public static final String ROLE_PREFIX = "gen";
    public static final String PROJECT_PREFIX = "gen_project";
    public static final String USER_PREFIX = "gen_user";
    public static final String USER_KIBANA_PREFIX = "gen_kibana";
    private static final String CLUSTER_HEADER = "cluster";
    private static final String INDICES_HEADER = "indices";
    private Map<String, Roles> roles = new HashMap<String, Roles>();
    private Long version;

    public SearchGuardRoles() {
    }

    public SearchGuardRoles(Long version) {
        if (version != null && version >= 0L) {
            this.version = version;
        }
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public Iterator<Roles> iterator() {
        return new ArrayList<Roles>(this.roles.values()).iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void removeRole(Roles role) {
        this.roles.remove(role.getName());
    }

    public void addAll(Collection<Roles> roles) {
        for (Roles role : roles) {
            this.roles.put(role.getName(), role);
        }
    }

    public static String formatUniqueKibanaRoleName(String username) {
        return String.format("%s_%s_%s", ROLE_PREFIX, "kibana", OpenshiftRequestContextFactory.getUsernameHash(username));
    }

    @Override
    public SearchGuardRoles load(Map<String, Object> source) {
        if (source == null) {
            return this;
        }
        RolesBuilder builder = new RolesBuilder();
        for (String key : source.keySet()) {
            RoleBuilder roleBuilder = new RoleBuilder(key);
            Map role = (Map)source.get(key);
            List cluster = (List)ObjectUtils.defaultIfNull(role.get(CLUSTER_HEADER), (Object)Collections.EMPTY_LIST);
            roleBuilder.setClusters(cluster);
            if (role.containsKey("expires")) {
                roleBuilder.expires((String)role.get("expires"));
            }
            Map indices = (Map)ObjectUtils.defaultIfNull(role.get(INDICES_HEADER), new HashMap());
            for (String index : indices.keySet()) {
                for (String type : ((Map)indices.get(index)).keySet()) {
                    List actions = (List)((Map)indices.get(index)).get(type);
                    roleBuilder.setActions(index, type, actions);
                }
            }
            builder.addRole(roleBuilder.build());
        }
        this.addAll(builder.build());
        return this;
    }

    @Override
    public String getType() {
        return "roles";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try {
            for (Roles role : this.roles.values()) {
                builder.startObject(role.getName());
                if (!role.getCluster().isEmpty()) {
                    builder.array(CLUSTER_HEADER, role.getCluster().toArray());
                }
                if (role.getExpire() != null) {
                    builder.field("expires", role.getExpire());
                }
                if (!role.getIndices().isEmpty()) {
                    builder.startObject(INDICES_HEADER);
                    role.getIndices().sort(new Comparator<Roles.Indices>(){

                        @Override
                        public int compare(Roles.Indices o1, Roles.Indices o2) {
                            return o1.getIndex().compareTo(o2.getIndex());
                        }
                    });
                    for (Roles.Indices index : role.getIndices()) {
                        if (index.getTypes().isEmpty()) continue;
                        builder.startObject(index.getIndex());
                        for (Roles.Indices.Type type : index.getTypes()) {
                            builder.array(type.getType(), type.getActions().toArray());
                        }
                        builder.endObject();
                    }
                    builder.endObject();
                }
                builder.endObject();
            }
            return builder;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert the SearchGuardRoles to JSON", e);
        }
    }

    public static class Roles {
        private String name;
        private String expires;
        private List<String> cluster = new ArrayList<String>();
        private List<Indices> indices = new ArrayList<Indices>();

        public Roles() {
        }

        public Roles(String name) {
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void setExpires(String expiresInMillies) {
            this.expires = expiresInMillies;
        }

        public String getExpire() {
            return this.expires;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getCluster() {
            return this.cluster;
        }

        public void setCluster(List<String> cluster) {
            this.cluster = cluster;
        }

        public void addClusterAction(String action) {
            this.cluster.add(action);
        }

        public void addIndexAction(Indices index) {
            this.indices.add(index);
        }

        public void addIndexAction(String index, String type, String action) {
            this.indices.add(new Indices(index, type, action));
        }

        public List<Indices> getIndices() {
            return this.indices;
        }

        public void setIndices(List<Indices> indices) {
            this.indices = indices;
        }

        public String toString() {
            return "name=" + this.getName() + "\n" + "expire=" + this.getExpire() + "\n";
        }

        public static class Indices {
            private String index;
            private List<Type> types;

            public Indices() {
            }

            public Indices(String index, String type, String action) {
                this.setIndex(index);
                this.setTypes(Arrays.asList(new Type(type, action)));
            }

            public String getIndex() {
                return this.index;
            }

            public void setIndex(String index) {
                this.index = index;
            }

            public List<Type> getTypes() {
                return this.types;
            }

            public void setTypes(List<Type> types) {
                this.types = types;
            }

            public String toString() {
                return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
            }

            public static class Type {
                private String type;
                private List<String> actions;

                public Type() {
                }

                public Type(String type, String action) {
                    this.type = type;
                    this.actions = Arrays.asList(action);
                }

                public String getType() {
                    return this.type;
                }

                public void setType(String type) {
                    this.type = type;
                }

                public List<String> getActions() {
                    return this.actions;
                }

                public void setActions(List<String> actions) {
                    this.actions = actions;
                }

                public String toString() {
                    return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
                }
            }
        }
    }
}

