/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesMappingSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.BaseRolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.RolesMappingBuilder;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRolesMapping;

public class ProjectRolesMappingSyncStrategy
extends BaseRolesMappingSyncStrategy {
    public ProjectRolesMappingSyncStrategy(SearchGuardRolesMapping rolesMapping, long expiresInMillis) {
        super(rolesMapping, expiresInMillis);
    }

    @Override
    protected void syncFromImpl(OpenshiftRequestContextFactory.OpenshiftRequestContext context, RolesMappingBuilder builder) {
        String username = context.getUser();
        for (String project : context.getProjects()) {
            String projectRoleName = String.format("%s_%s", "gen_project", project.replace('.', '_'));
            builder.addUser(projectRoleName, username);
        }
        if (context.isOperationsUser()) {
            builder.addUser("gen_project_operations", username).expire(this.getExpires());
        }
        String kibanaRoleName = BaseRolesSyncStrategy.formatKibanaRoleName(context);
        builder.addUser(kibanaRoleName, username).expire(this.getExpires());
    }
}

