/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import com.floragunn.searchguard.SearchGuardPlugin;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexAction;
import io.fabric8.elasticsearch.plugin.OpenShiftElasticSearchService;
import io.fabric8.elasticsearch.plugin.OpenshiftAPIService;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginClient;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.ACLDocumentManager;
import io.fabric8.elasticsearch.plugin.acl.DynamicACLFilter;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardSyncStrategyFactory;
import io.fabric8.elasticsearch.plugin.filter.FieldStatsResponseFilter;
import io.fabric8.elasticsearch.plugin.kibana.IndexMappingLoader;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.elasticsearch.util.RequestUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.component.LifecycleComponent;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.http.HttpServerTransport;
import org.elasticsearch.index.IndexModule;
import org.elasticsearch.indices.breaker.CircuitBreakerService;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.plugins.NetworkPlugin;
import org.elasticsearch.plugins.Plugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.Transport;
import org.elasticsearch.transport.TransportInterceptor;
import org.elasticsearch.watcher.ResourceWatcherService;

public class OpenShiftElasticSearchPlugin
extends Plugin
implements ConfigurationSettings,
ActionPlugin,
NetworkPlugin {
    private final Settings settings;
    private KibanaUserReindexAction kibanaReindexAction;
    private DynamicACLFilter aclFilter;
    private SearchGuardPlugin sgPlugin;

    public OpenShiftElasticSearchPlugin(Settings settings) {
        this.settings = settings;
        this.sgPlugin = new SearchGuardPlugin(settings);
    }

    public Collection<Object> createComponents(Client client, ClusterService clusterService, ThreadPool threadPool, ResourceWatcherService resourceWatcherService, ScriptService scriptService, NamedXContentRegistry namedXContentRegistry) {
        PluginSettings pluginSettings = new PluginSettings(this.settings);
        IndexMappingLoader indexMappingLoader = new IndexMappingLoader(this.settings);
        PluginClient pluginClient = new PluginClient(client, threadPool.getThreadContext());
        OpenshiftAPIService apiService = new OpenshiftAPIService();
        RequestUtils requestUtils = new RequestUtils(pluginSettings, apiService);
        OpenshiftRequestContextFactory contextFactory = new OpenshiftRequestContextFactory(this.settings, requestUtils, apiService);
        SearchGuardSyncStrategyFactory documentFactory = new SearchGuardSyncStrategyFactory(pluginSettings);
        KibanaSeed seed = new KibanaSeed(pluginSettings, indexMappingLoader, pluginClient);
        ACLDocumentManager aclDocumentManager = new ACLDocumentManager(pluginClient, pluginSettings, documentFactory, threadPool);
        this.aclFilter = new DynamicACLFilter(pluginSettings, seed, client, contextFactory, threadPool, requestUtils, aclDocumentManager);
        this.kibanaReindexAction = new KibanaUserReindexAction(pluginSettings, client, threadPool.getThreadContext());
        OpenShiftElasticSearchService osElasticService = new OpenShiftElasticSearchService(aclDocumentManager, pluginSettings);
        clusterService.addLocalNodeMasterListener((LocalNodeMasterListener)osElasticService);
        ArrayList<Object> list = new ArrayList<Object>();
        list.add(aclDocumentManager);
        list.add(pluginSettings);
        list.add(indexMappingLoader);
        list.add(pluginClient);
        list.add(requestUtils);
        list.add(apiService);
        list.add(contextFactory);
        list.add(documentFactory);
        list.add(seed);
        list.add(this.aclFilter);
        list.add(this.kibanaReindexAction);
        list.add(osElasticService);
        list.add(new FieldStatsResponseFilter(pluginClient));
        list.addAll(this.sgPlugin.createComponents(client, clusterService, threadPool, resourceWatcherService, scriptService, namedXContentRegistry));
        return list;
    }

    public UnaryOperator<RestHandler> getRestHandlerWrapper(ThreadContext threadContext) {
        return rh -> this.aclFilter.wrap((RestHandler)rh, this.sgPlugin.getRestHandlerWrapper(threadContext));
    }

    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> list = new ArrayList<RestHandler>();
        list.addAll(this.sgPlugin.getRestHandlers(settings, restController, clusterSettings, indexScopedSettings, settingsFilter, indexNameExpressionResolver, nodesInCluster));
        return list;
    }

    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> list = new ArrayList<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>>();
        list.addAll(this.sgPlugin.getActions());
        return list;
    }

    public void onIndexModule(IndexModule indexModule) {
        this.sgPlugin.onIndexModule(indexModule);
    }

    public List<Class<? extends ActionFilter>> getActionFilters() {
        ArrayList<Class<? extends ActionFilter>> list = new ArrayList<Class<? extends ActionFilter>>();
        list.add(FieldStatsResponseFilter.class);
        list.add(KibanaUserReindexAction.class);
        list.addAll(this.sgPlugin.getActionFilters());
        return list;
    }

    public List<TransportInterceptor> getTransportInterceptors(ThreadContext threadContext) {
        ArrayList<TransportInterceptor> list = new ArrayList<TransportInterceptor>();
        list.addAll(this.sgPlugin.getTransportInterceptors(threadContext));
        return list;
    }

    public Map<String, Supplier<Transport>> getTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NetworkService networkService) {
        Map transports = this.sgPlugin.getTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, networkService);
        return transports;
    }

    public Map<String, Supplier<HttpServerTransport>> getHttpTransports(Settings settings, ThreadPool threadPool, BigArrays bigArrays, CircuitBreakerService circuitBreakerService, NamedWriteableRegistry namedWriteableRegistry, NamedXContentRegistry namedXContentRegistry, NetworkService networkService, HttpServerTransport.Dispatcher dispatcher) {
        Map transports = this.sgPlugin.getHttpTransports(settings, threadPool, bigArrays, circuitBreakerService, namedWriteableRegistry, namedXContentRegistry, networkService, dispatcher);
        return transports;
    }

    public Collection<Class<? extends LifecycleComponent>> getGuiceServiceClasses() {
        Collection serviceClasses = this.sgPlugin.getGuiceServiceClasses();
        return serviceClasses;
    }

    public Settings additionalSettings() {
        return Settings.builder().put(this.sgPlugin.additionalSettings()).build();
    }

    public List<Setting<?>> getSettings() {
        List settings = this.sgPlugin.getSettings();
        settings.add(Setting.simpleString((String)"io.fabric8.elasticsearch.kibana.mapping.app", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"io.fabric8.elasticsearch.kibana.mapping.ops", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"io.fabric8.elasticsearch.kibana.mapping.empty", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)"openshift.config.use_common_data_model", (boolean)true, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"openshift.config.project_index_prefix", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"openshift.config.time_field_name", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"openshift.searchguard.keystore.path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"openshift.searchguard.truststore.path", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.boolSetting((String)"openshift.operations.allow_cluster_reader", (boolean)false, (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"openshift.kibana.index.mode", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        settings.add(Setting.simpleString((String)"openshift.acl.role_strategy", (Setting.Property[])new Setting.Property[]{Setting.Property.NodeScope}));
        return settings;
    }

    public List<String> getSettingsFilter() {
        List filter = this.sgPlugin.getSettingsFilter();
        filter.add("openshift.*");
        filter.add("io.fabric8.elasticsearch.*");
        return filter;
    }

    public void close() throws IOException {
        if (this.sgPlugin != null) {
            this.sgPlugin.close();
        }
        super.close();
    }
}

