/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.kubernetes.api.model;

import io.fabric8.kubernetes.api.builder.VisitableBuilder;
import io.fabric8.kubernetes.api.model.NamespaceSpec;
import io.fabric8.kubernetes.api.model.NamespaceSpecFluent;
import io.fabric8.kubernetes.api.model.NamespaceSpecFluentImpl;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;

public class NamespaceSpecBuilder
extends NamespaceSpecFluentImpl<NamespaceSpecBuilder>
implements VisitableBuilder<NamespaceSpec, NamespaceSpecBuilder> {
    NamespaceSpecFluent<?> fluent;
    Boolean validationEnabled;

    public NamespaceSpecBuilder() {
        this(true);
    }

    public NamespaceSpecBuilder(Boolean validationEnabled) {
        this(new NamespaceSpec(), validationEnabled);
    }

    public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent) {
        this(fluent, (Boolean)true);
    }

    public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent, Boolean validationEnabled) {
        this(fluent, new NamespaceSpec(), validationEnabled);
    }

    public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent, NamespaceSpec instance) {
        this(fluent, instance, true);
    }

    public NamespaceSpecBuilder(NamespaceSpecFluent<?> fluent, NamespaceSpec instance, Boolean validationEnabled) {
        this.fluent = fluent;
        fluent.withFinalizers(instance.getFinalizers());
        this.validationEnabled = validationEnabled;
    }

    public NamespaceSpecBuilder(NamespaceSpec instance) {
        this(instance, (Boolean)true);
    }

    public NamespaceSpecBuilder(NamespaceSpec instance, Boolean validationEnabled) {
        this.fluent = this;
        this.withFinalizers(instance.getFinalizers());
        this.validationEnabled = validationEnabled;
    }

    @Override
    public NamespaceSpec build() {
        NamespaceSpec buildable = new NamespaceSpec(this.fluent.getFinalizers());
        this.validate(buildable);
        return buildable;
    }

    private <T> void validate(T item) {
        if (!this.validationEnabled.booleanValue()) {
            return;
        }
        Validator validator = null;
        try {
            ValidatorFactory factory = Validation.buildDefaultValidatorFactory();
            validator = factory.getValidator();
        }
        catch (ValidationException e) {
            return;
        }
        Set violations = validator.validate(item, new Class[0]);
        if (!violations.isEmpty()) {
            throw new ConstraintViolationException(violations);
        }
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        NamespaceSpecBuilder that = (NamespaceSpecBuilder)o;
        if (this.fluent != null && this.fluent != this ? !this.fluent.equals(that.fluent) : that.fluent != null && this.fluent != this) {
            return false;
        }
        return !(this.validationEnabled != null ? !this.validationEnabled.equals(that.validationEnabled) : that.validationEnabled != null);
    }
}

