/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.acl.SearchGuardACLDocument;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang.builder.ToStringBuilder;
import org.apache.commons.lang.builder.ToStringStyle;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class SearchGuardRolesMapping
implements Iterable<RolesMapping>,
SearchGuardACLDocument<SearchGuardRolesMapping> {
    public static final String ADMIN_ROLE = "gen_project_operations";
    public static final String KIBANA_SHARED_ROLE = "gen_ocp_kibana_shared";
    private static final String USER_HEADER = "users";
    private Map<String, RolesMapping> mappings = new HashMap<String, RolesMapping>();
    private Long version;

    public SearchGuardRolesMapping() {
    }

    public SearchGuardRolesMapping(Long version) {
        if (version != null && version >= 0L) {
            this.version = version;
        }
    }

    @Override
    public Long getVersion() {
        return this.version;
    }

    @Override
    public Iterator<RolesMapping> iterator() {
        return new ArrayList<RolesMapping>(this.mappings.values()).iterator();
    }

    public String toString() {
        return ToStringBuilder.reflectionToString((Object)this, (ToStringStyle)ToStringStyle.SHORT_PREFIX_STYLE);
    }

    public void removeRolesMapping(RolesMapping mapping) {
        this.mappings.remove(mapping.getName());
    }

    @Override
    public SearchGuardRolesMapping load(Map<String, Object> source) {
        if (source == null) {
            return this;
        }
        for (String key : source.keySet()) {
            Map rawMappings = (Map)source.get(key);
            RolesMapping mapping = new RolesMapping();
            mapping.setName(key);
            mapping.setUsers((List)rawMappings.get(USER_HEADER));
            if (rawMappings.containsKey("expires")) {
                mapping.setExpire((String)rawMappings.get("expires"));
            }
            this.mappings.put(mapping.getName(), mapping);
        }
        return this;
    }

    @Override
    public String getType() {
        return "rolesmapping";
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        try {
            for (RolesMapping mapping : this.mappings.values()) {
                builder.startObject(mapping.getName());
                if (mapping.getExpire() != null) {
                    builder.field("expires", mapping.getExpire());
                }
                builder.array(USER_HEADER, mapping.getUsers().toArray());
                builder.endObject();
            }
            return builder;
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to convert the SearchGuardRolesMapping to JSON", e);
        }
    }

    public void addAll(Collection<RolesMapping> mappings) {
        for (RolesMapping rolesMapping : mappings) {
            if (this.mappings.containsKey(rolesMapping.getName())) {
                this.mappings.get(rolesMapping.getName()).addAll(rolesMapping.getUsers());
                continue;
            }
            this.mappings.put(rolesMapping.getName(), rolesMapping);
        }
    }

    public static class RolesMapping {
        private Boolean protect;
        private String name;
        private Set<String> users = new HashSet<String>();
        private String expire;

        public Boolean getProtected() {
            return this.protect;
        }

        public void setProtected(boolean protect) {
            this.protect = protect;
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public Collection<String> getUsers() {
            return this.users;
        }

        public void setUsers(Collection<String> users) {
            this.users = new HashSet<String>(users);
        }

        public String toString() {
            return "name=" + this.getName() + "\n" + "expire=" + this.getExpire() + "\n" + "users=" + this.getUsers().toArray() + "\n";
        }

        public void addAll(Collection<String> users) {
            this.users.addAll(users);
        }

        public void setExpire(String expire) {
            this.expire = expire;
        }

        public String getExpire() {
            return this.expire;
        }
    }
}

