/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import java.net.InetSocketAddress;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestRequest;

class RemoteIpDetector {
    private static final Pattern commaSeparatedValuesPattern = Pattern.compile("\\s*,\\s*");
    protected final Logger log = LogManager.getLogger(this.getClass());
    private Pattern internalProxies = Pattern.compile("10\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|192\\.168\\.\\d{1,3}\\.\\d{1,3}|169\\.254\\.\\d{1,3}\\.\\d{1,3}|127\\.\\d{1,3}\\.\\d{1,3}\\.\\d{1,3}|172\\.1[6-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.2[0-9]{1}\\.\\d{1,3}\\.\\d{1,3}|172\\.3[0-1]{1}\\.\\d{1,3}\\.\\d{1,3}");
    private String proxiesHeader = "X-Forwarded-By";
    private String remoteIpHeader = "X-Forwarded-For";
    private Pattern trustedProxies = null;

    RemoteIpDetector() {
    }

    protected static String[] commaDelimitedListToStringArray(String commaDelimitedStrings) {
        return commaDelimitedStrings == null || commaDelimitedStrings.length() == 0 ? new String[]{} : commaSeparatedValuesPattern.split(commaDelimitedStrings);
    }

    protected static String listToCommaDelimitedString(List<String> stringList) {
        if (stringList == null) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        Iterator<String> it = stringList.iterator();
        while (it.hasNext()) {
            String element = it.next();
            if (element == null) continue;
            result.append((Object)element);
            if (!it.hasNext()) continue;
            result.append(", ");
        }
        return result.toString();
    }

    public String getInternalProxies() {
        if (this.internalProxies == null) {
            return null;
        }
        return this.internalProxies.toString();
    }

    public String getProxiesHeader() {
        return this.proxiesHeader;
    }

    public String getRemoteIpHeader() {
        return this.remoteIpHeader;
    }

    public String getTrustedProxies() {
        if (this.trustedProxies == null) {
            return null;
        }
        return this.trustedProxies.toString();
    }

    String detect(RestRequest request, ThreadContext threadContext) {
        String originalRemoteAddr = ((InetSocketAddress)request.getRemoteAddress()).getAddress().getHostAddress();
        String originalProxiesHeader = request.header(this.proxiesHeader);
        if (this.log.isTraceEnabled()) {
            this.log.trace("originalRemoteAddr {}", (Object)originalRemoteAddr);
        }
        if (this.internalProxies != null && this.internalProxies.matcher(originalRemoteAddr).matches()) {
            int idx;
            String remoteIp = null;
            LinkedList<String> proxiesHeaderValue = new LinkedList<String>();
            StringBuilder concatRemoteIpHeaderValue = new StringBuilder();
            List remoteIpHeaders = request.getAllHeaderValues(this.remoteIpHeader);
            if (remoteIpHeaders == null || remoteIpHeaders.isEmpty()) {
                return originalRemoteAddr;
            }
            for (String rh : remoteIpHeaders) {
                if (concatRemoteIpHeaderValue.length() > 0) {
                    concatRemoteIpHeaderValue.append(", ");
                }
                concatRemoteIpHeaderValue.append(rh);
            }
            if (this.log.isTraceEnabled()) {
                this.log.trace("concatRemoteIpHeaderValue {}", (Object)concatRemoteIpHeaderValue.toString());
            }
            String[] remoteIpHeaderValue = RemoteIpDetector.commaDelimitedListToStringArray(concatRemoteIpHeaderValue.toString());
            for (idx = remoteIpHeaderValue.length - 1; idx >= 0; --idx) {
                String currentRemoteIp;
                remoteIp = currentRemoteIp = remoteIpHeaderValue[idx];
                if (this.internalProxies.matcher(currentRemoteIp).matches()) continue;
                if (this.trustedProxies != null && this.trustedProxies.matcher(currentRemoteIp).matches()) {
                    proxiesHeaderValue.addFirst(currentRemoteIp);
                    continue;
                }
                --idx;
                break;
            }
            LinkedList<String> newRemoteIpHeaderValue = new LinkedList<String>();
            while (idx >= 0) {
                String currentRemoteIp = remoteIpHeaderValue[idx];
                newRemoteIpHeaderValue.addFirst(currentRemoteIp);
                --idx;
            }
            if (remoteIp != null) {
                if (this.log.isTraceEnabled()) {
                    String originalRemoteHost = ((InetSocketAddress)request.getRemoteAddress()).getAddress().getHostName();
                    this.log.trace("Incoming request " + request.uri() + " with originalRemoteAddr '" + originalRemoteAddr + "', originalRemoteHost='" + originalRemoteHost + "', will be seen as newRemoteAddr='" + remoteIp);
                }
                threadContext.putTransient("_sg_xff_done", (Object)Boolean.TRUE);
                return remoteIp;
            }
            this.log.warn("Remote ip could not be detected, this should normally not happen");
        } else if (this.log.isTraceEnabled()) {
            this.log.trace("Skip RemoteIpDetector for request " + request.uri() + " with originalRemoteAddr '" + request.getRemoteAddress() + "' cause no internal proxy matches");
        }
        return originalRemoteAddr;
    }

    public void setInternalProxies(String internalProxies) {
        this.internalProxies = internalProxies == null || internalProxies.length() == 0 ? null : Pattern.compile(internalProxies);
    }

    public void setProxiesHeader(String proxiesHeader) {
        this.proxiesHeader = proxiesHeader;
    }

    public void setRemoteIpHeader(String remoteIpHeader) {
        this.remoteIpHeader = remoteIpHeader;
    }

    public void setTrustedProxies(String trustedProxies) {
        this.trustedProxies = trustedProxies == null || trustedProxies.length() == 0 ? null : Pattern.compile(trustedProxies);
    }
}

