/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.configuration;

import com.floragunn.searchguard.configuration.AdminDNs;
import com.floragunn.searchguard.configuration.EmptyReader;
import com.floragunn.searchguard.support.HeaderHelper;
import com.floragunn.searchguard.user.User;
import java.io.IOException;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.lucene.index.DirectoryReader;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.IndexSearcher;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.index.Index;
import org.elasticsearch.index.IndexService;
import org.elasticsearch.index.engine.EngineException;
import org.elasticsearch.index.shard.IndexSearcherWrapper;

public class SearchGuardIndexSearcherWrapper
extends IndexSearcherWrapper {
    protected final Logger log = LogManager.getLogger(((Object)((Object)this)).getClass());
    protected final ThreadContext threadContext;
    protected final Index index;
    protected final String searchguardIndex;

    public SearchGuardIndexSearcherWrapper(IndexService indexService, Settings settings) {
        this.index = indexService.index();
        this.threadContext = indexService.getThreadPool().getThreadContext();
        this.searchguardIndex = settings.get("searchguard.config_index_name", "searchguard");
    }

    public final DirectoryReader wrap(DirectoryReader reader) throws IOException {
        if (!this.isAdminAuthenticatedOrInternalRequest()) {
            return this.dlsFlsWrap(reader);
        }
        return reader;
    }

    public final IndexSearcher wrap(IndexSearcher searcher) throws EngineException {
        if (this.isSearchGuardIndexRequest() && !this.isAdminAuthenticatedOrInternalRequest()) {
            return new IndexSearcher((IndexReader)new EmptyReader(searcher.getIndexReader().getCoreCacheKey()));
        }
        if (!this.isAdminAuthenticatedOrInternalRequest()) {
            return this.dlsFlsWrap(searcher);
        }
        return searcher;
    }

    protected IndexSearcher dlsFlsWrap(IndexSearcher searcher) throws EngineException {
        return searcher;
    }

    protected DirectoryReader dlsFlsWrap(DirectoryReader reader) throws IOException {
        return reader;
    }

    protected final boolean isAdminAuthenticatedOrInternalRequest() {
        User user = (User)this.threadContext.getTransient("_sg_user");
        if (user != null && AdminDNs.isAdmin(user.getName())) {
            return true;
        }
        return "true".equals(HeaderHelper.getSafeFromHeader(this.threadContext, "_sg_conf_request"));
    }

    protected final boolean isSearchGuardIndexRequest() {
        return this.index.getName().equals(this.searchguardIndex);
    }
}

