/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.acl.RolesBuilder;
import io.fabric8.elasticsearch.plugin.acl.RolesSyncStrategy;
import io.fabric8.elasticsearch.plugin.acl.SearchGuardRoles;

public abstract class BaseRolesSyncStrategy
implements RolesSyncStrategy {
    protected SearchGuardRoles roles;
    private final String userProfilePrefix;

    protected BaseRolesSyncStrategy(SearchGuardRoles roles, String userProfilePrefix) {
        this.roles = roles;
        this.userProfilePrefix = userProfilePrefix;
    }

    protected abstract void syncFromImpl(OpenshiftRequestContextFactory.OpenshiftRequestContext var1, RolesBuilder var2);

    @Override
    public void syncFrom(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        RolesBuilder builder = new RolesBuilder();
        this.syncFromImpl(context, builder);
        this.roles.addAll(builder.build());
    }

    protected String formatKibanaIndexName(OpenshiftRequestContextFactory.OpenshiftRequestContext context, String kibanaIndexMode) {
        String kibanaIndex = OpenshiftRequestContextFactory.getKibanaIndex(this.userProfilePrefix, kibanaIndexMode, context.getUser(), context.isOperationsUser());
        return kibanaIndex.replace('.', '?');
    }

    protected String formatKibanaRoleName(OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        if (context.isOperationsUser()) {
            return "gen_ocp_kibana_shared";
        }
        return SearchGuardRoles.formatUniqueKibanaRoleName(context.getUser());
    }

    public static String formatUserRoleName(String username) {
        return String.format("%s_%s", "gen_user", OpenshiftRequestContextFactory.getUsernameHash(username));
    }

    public static String formatUserKibanaRoleName(String username) {
        return String.format("%s_%s", "gen_kibana", OpenshiftRequestContextFactory.getUsernameHash(username));
    }
}

