/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.util;

import com.squareup.okhttp.Request;
import com.squareup.okhttp.Response;
import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftClientFactory;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.kubernetes.client.Config;
import io.fabric8.kubernetes.client.ConfigBuilder;
import io.fabric8.openshift.api.model.SubjectAccessReviewResponse;
import io.fabric8.openshift.client.DefaultOpenShiftClient;
import io.fabric8.openshift.client.NamespacedOpenShiftClient;
import io.fabric8.openshift.client.dsl.CreateableSubjectAccessReview;
import io.netty.channel.Channel;
import java.net.SocketAddress;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.SpecialPermission;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestStatus;

public class RequestUtils
implements ConfigurationSettings {
    private static final Logger LOGGER = Loggers.getLogger(RequestUtils.class);
    public static final String AUTHORIZATION_HEADER = "Authorization";
    private final String proxyUserHeader;
    private final OpenshiftClientFactory k8ClientFactory;
    private final String defaultKibanaIndex;

    public RequestUtils(PluginSettings pluginSettings, OpenshiftClientFactory clientFactory) {
        this.defaultKibanaIndex = pluginSettings.getDefaultKibanaIndex();
        this.proxyUserHeader = pluginSettings.getSettings().get("searchguard.authentication.proxy.header", "X-Proxy-Remote-User");
        this.k8ClientFactory = clientFactory;
    }

    public boolean hasUserHeader(RestRequest request) {
        return StringUtils.isNotEmpty((String)this.getUser(request));
    }

    public String getUser(RestRequest request) {
        return StringUtils.defaultIfEmpty((String)request.header(this.proxyUserHeader), (String)"");
    }

    public String getBearerToken(RestRequest request) {
        String[] auth = StringUtils.defaultIfEmpty((String)request.header(AUTHORIZATION_HEADER), (String)"").split(" ");
        if (auth.length >= 2 && "Bearer".equals(auth[0])) {
            return auth[1];
        }
        return "";
    }

    public boolean isClientCertAuth(ThreadContext threadContext) {
        return threadContext != null && StringUtils.isNotEmpty((String)((String)threadContext.getTransient("_sg_ssl_transport_principal")));
    }

    public boolean isOperationsUser(final RestRequest request) {
        return this.executePrivilegedAction(new PrivilegedAction<Boolean>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Boolean run() {
                String user = StringUtils.defaultIfEmpty((String)RequestUtils.this.getUser(request), (String)"<UNKNOWN>");
                String token = RequestUtils.this.getBearerToken(request);
                boolean allowed = false;
                Config config = ((ConfigBuilder)new ConfigBuilder().withOauthToken(token)).build();
                try (NamespacedOpenShiftClient osClient = (NamespacedOpenShiftClient)RequestUtils.this.k8ClientFactory.create(config);){
                    LOGGER.debug("Submitting a SAR to see if '{}' is able to retrieve logs across the cluster", (Object)user);
                    SubjectAccessReviewResponse response = (SubjectAccessReviewResponse)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((CreateableSubjectAccessReview)((NamespacedOpenShiftClient)osClient.inAnyNamespace()).subjectAccessReviews().createNew()).withVerb("get")).withResource("pods/log")).done();
                    allowed = response.getAllowed();
                }
                catch (Exception e) {
                    LOGGER.error("Exception determining user's '{}' role: {}", (Object)user, (Object)e);
                }
                finally {
                    LOGGER.debug("User '{}' isOperationsUser: {}", (Object)user, (Object)allowed);
                }
                return allowed;
            }
        });
    }

    private <T> T executePrivilegedAction(PrivilegedAction<T> action) {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission((Permission)new SpecialPermission());
        }
        return AccessController.doPrivileged(action);
    }

    public String assertUser(final RestRequest request) {
        return this.executePrivilegedAction(new PrivilegedAction<String>(){

            @Override
            public String run() {
                String username = null;
                String user = RequestUtils.this.getUser(request);
                String token = RequestUtils.this.getBearerToken(request);
                ConfigBuilder builder = (ConfigBuilder)new ConfigBuilder().withOauthToken(token);
                try (DefaultOpenShiftClient osClient = new DefaultOpenShiftClient(builder.build());){
                    LOGGER.debug("Verifying user {} matches the given token.", (Object)user);
                    Request okRequest = new Request.Builder().addHeader(RequestUtils.AUTHORIZATION_HEADER, "Bearer " + token).url(osClient.getMasterUrl() + "oapi/v1/users/~").build();
                    Response response = null;
                    try {
                        response = osClient.getHttpClient().newCall(okRequest).execute();
                        String body = response.body().string();
                        if (LOGGER.isDebugEnabled()) {
                            LOGGER.debug("Response: code '{}' {}", (Object)response.code(), (Object)body);
                        }
                        if (response.code() != RestStatus.OK.getStatus()) {
                            throw new ElasticsearchSecurityException("", RestStatus.UNAUTHORIZED, new Object[0]);
                        }
                        Map userResponse = XContentHelper.convertToMap((XContent)XContentFactory.xContent((CharSequence)body), (String)body, (boolean)false);
                        if (userResponse.containsKey("metadata") && ((Map)userResponse.get("metadata")).containsKey("name")) {
                            username = (String)((Map)userResponse.get("metadata")).get("name");
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Exception trying to assertUser '{}'", (Object)e, (Object)user);
                    }
                    if (StringUtils.isNotBlank(username) && StringUtils.isNotBlank((String)user) && !user.equals(username)) {
                        String message = String.format("The given username '%s' does not match the username '%s' associated with the token provided with the request.", user, username);
                        LOGGER.debug(message);
                    }
                }
                if (null == username) {
                    throw new ElasticsearchSecurityException("", RestStatus.UNAUTHORIZED, new Object[0]);
                }
                return username;
            }
        });
    }

    public RestRequest modifyRequest(final RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context, final RestChannel channel) {
        final String uri = this.getUri(request, context);
        final BytesReference content = this.getContent(request, context);
        if (!this.getUser(request).equals(context.getUser()) || !uri.equals(request.uri()) || content != request.content()) {
            LOGGER.debug("Modifying header '{}' to be '{}'", (Object)this.proxyUserHeader, (Object)context.getUser());
            TreeMap<String, List<String>> modifiedHeaders = new TreeMap<String, List<String>>(String.CASE_INSENSITIVE_ORDER);
            modifiedHeaders.putAll(request.getHeaders());
            modifiedHeaders.put(this.proxyUserHeader, Arrays.asList(context.getUser()));
            if (request.header("Content-Type") != null && request.header("Content-Type").toLowerCase().endsWith("json")) {
                modifiedHeaders.put("Content-Type", Arrays.asList("application/json"));
            }
            RestRequest modified = new RestRequest(request.getXContentRegistry(), uri, modifiedHeaders){

                public RestRequest.Method method() {
                    return request.method();
                }

                public String uri() {
                    return uri;
                }

                public boolean hasContent() {
                    return content.length() > 0;
                }

                public BytesReference content() {
                    return content;
                }

                public SocketAddress getRemoteAddress() {
                    return request.getRemoteAddress();
                }

                public SocketAddress getLocalAddress() {
                    return request.getRemoteAddress();
                }

                public Channel getChannel() {
                    return (Channel)channel;
                }
            };
            modified.params().putAll(request.params());
            if (uri.contains(this.defaultKibanaIndex)) {
                modified.params().put("index", context.getKibanaIndex());
            }
            return modified;
        }
        return request;
    }

    private BytesReference getContent(RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        String content = request.content().utf8ToString();
        if (content.contains("_index\":\"" + this.defaultKibanaIndex)) {
            LOGGER.debug("Replacing the content that references the default kibana index");
            String replaced = content.replaceAll("_index\":\"" + this.defaultKibanaIndex + "\"", "_index\":\"" + context.getKibanaIndex() + "\"");
            return new BytesArray(replaced);
        }
        return request.content();
    }

    private String getUri(RestRequest request, OpenshiftRequestContextFactory.OpenshiftRequestContext context) {
        if (request.uri().contains(this.defaultKibanaIndex) && !context.getKibanaIndex().equals(this.defaultKibanaIndex)) {
            String uri = request.uri().replaceAll(this.defaultKibanaIndex, context.getKibanaIndex());
            LOGGER.debug("Modifying uri to be '{}'", (Object)uri);
            return uri;
        }
        return request.uri();
    }
}

