/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.auth;

import com.floragunn.searchguard.action.configupdate.TransportConfigUpdateAction;
import com.floragunn.searchguard.auth.AuthenticationBackend;
import com.floragunn.searchguard.auth.HTTPAuthenticator;
import com.floragunn.searchguard.user.AuthCredentials;
import com.floragunn.searchguard.user.User;
import io.fabric8.elasticsearch.plugin.OpenShiftElasticSearchConfigurationException;
import java.io.File;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.DatatypeConverter;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.StringUtils;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.loader.YamlSettingsLoader;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;

public class FileAuthenticationBackend
implements AuthenticationBackend,
HTTPAuthenticator {
    private static final String PASSWD = ".passwd";
    protected static final String FILE = "file_path";
    private final File auth;
    private Settings mappings;
    private long lastModified;

    public FileAuthenticationBackend(Settings settings) {
        this(settings, null);
    }

    public FileAuthenticationBackend(Settings settings, TransportConfigUpdateAction tcua) {
        String file = settings.get(FILE);
        if (StringUtils.isBlank((String)file)) {
            throw new OpenShiftElasticSearchConfigurationException("Unable to Configure FileAuthenticationBackend because file_path is empty");
        }
        this.auth = FileUtils.getFile((String[])new String[]{file});
        if (!this.auth.exists()) {
            throw new OpenShiftElasticSearchConfigurationException("Unable to Configure YmlFileAuthenticationBackend because file_path does not exist: " + file);
        }
        this.loadAuthFile();
    }

    public AuthCredentials extractCredentials(RestRequest request, ThreadContext context) throws ElasticsearchSecurityException {
        String authorizationHeader = request.header("Authorization");
        if (authorizationHeader != null && authorizationHeader.trim().toLowerCase().startsWith("basic ")) {
            String decoded = new String(DatatypeConverter.parseBase64Binary((String)authorizationHeader.split(" ")[1]), StandardCharsets.UTF_8);
            int delimiter = decoded.lastIndexOf(58);
            String username = null;
            String password = null;
            if (delimiter > 0) {
                username = decoded.substring(0, delimiter);
                if (decoded.length() - 1 != delimiter) {
                    password = decoded.substring(delimiter + 1).trim();
                }
            }
            if (username != null && StringUtils.isNotEmpty(password)) {
                return new AuthCredentials(username, password.getBytes(StandardCharsets.UTF_8)).markComplete();
            }
        }
        return null;
    }

    public boolean reRequestAuthentication(RestChannel channel, AuthCredentials credentials) {
        return false;
    }

    public String getType() {
        return FileAuthenticationBackend.class.getName();
    }

    public User authenticate(AuthCredentials credentials) throws ElasticsearchSecurityException {
        String presented;
        String saved;
        String hash;
        if (credentials == null) {
            throw new ElasticsearchSecurityException("Creditials are null while trying to authenticate", new Object[0]);
        }
        Settings settings = this.loadAuthFile();
        if (this.exists(settings, credentials.getUsername()) && StringUtils.isNotBlank((String)(hash = settings.get(credentials.getUsername() + PASSWD))) && (saved = new String(DatatypeConverter.parseBase64Binary((String)hash), StandardCharsets.UTF_8).trim()).equals(presented = new String(credentials.getPassword()))) {
            return new User(credentials.getUsername());
        }
        throw new ElasticsearchSecurityException("Unable to authenticate {}", new Object[]{credentials.getUsername()});
    }

    public boolean exists(User user) {
        if (user == null || user.getName() == null) {
            return false;
        }
        Settings settings = this.loadAuthFile();
        return this.exists(settings, user.getName());
    }

    private boolean exists(Settings settings, String username) {
        return settings.names().contains(username);
    }

    private Settings loadAuthFile() {
        long now = this.auth.lastModified();
        if (now > this.lastModified) {
            try {
                String ref = FileUtils.readFileToString((File)this.auth);
                this.mappings = Settings.builder().put(new YamlSettingsLoader(true).load(ref)).build();
                this.lastModified = now;
            }
            catch (Exception e) {
                throw new OpenShiftElasticSearchConfigurationException("Unable to parse " + this.auth.getAbsolutePath(), e);
            }
        }
        return this.mappings;
    }
}

