/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin.acl;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.ACLDocumentManager;
import io.fabric8.elasticsearch.plugin.kibana.KibanaSeed;
import io.fabric8.elasticsearch.util.RequestUtils;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.UnaryOperator;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchSecurityException;
import org.elasticsearch.client.Client;
import org.elasticsearch.client.node.NodeClient;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.threadpool.ThreadPool;

public class DynamicACLFilter
implements ConfigurationSettings {
    private static final Logger LOGGER = Loggers.getLogger(DynamicACLFilter.class);
    private final String kibanaVersion;
    private final String kbnVersionHeader;
    private Boolean enabled;
    private final String cdmProjectPrefix;
    private KibanaSeed kibanaSeed;
    private final ACLDocumentManager aclManager;
    private final OpenshiftRequestContextFactory contextFactory;
    private final RequestUtils utils;
    private final ThreadPool threadPool;

    public DynamicACLFilter(PluginSettings settings, KibanaSeed seed, Client client, OpenshiftRequestContextFactory contextFactory, ThreadPool threadPool, RequestUtils utils, ACLDocumentManager aclManager) {
        this.threadPool = threadPool;
        this.kibanaSeed = seed;
        this.contextFactory = contextFactory;
        this.kibanaVersion = settings.getKibanaVersion();
        this.kbnVersionHeader = settings.getKbnVersionHeader();
        this.cdmProjectPrefix = settings.getCdmProjectPrefix();
        this.enabled = settings.isEnabled();
        this.utils = utils;
        this.aclManager = aclManager;
    }

    public RestHandler wrap(final RestHandler original, final UnaryOperator<RestHandler> unaryOperator) {
        return new RestHandler(){

            public void handleRequest(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
                if ((request = DynamicACLFilter.this.continueProcessing(request, channel, client)) != null) {
                    RestHandler handler = (RestHandler)unaryOperator.apply(original);
                    handler.handleRequest(request, channel, client);
                }
            }
        };
    }

    public RestRequest continueProcessing(RestRequest request, RestChannel channel, NodeClient client) throws Exception {
        try {
            OpenshiftRequestContextFactory.OpenshiftRequestContext requestContext = OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY;
            try (ThreadContext.StoredContext threadContext = this.threadPool.getThreadContext().stashContext();){
                if (this.enabled.booleanValue() && (requestContext = this.contextFactory.create(request)) != OpenshiftRequestContextFactory.OpenshiftRequestContext.EMPTY) {
                    request = this.utils.modifyRequest(request, requestContext, channel);
                    this.logRequest(request);
                    String kbnVersion = this.getKibanaVersion(request);
                    this.kibanaSeed.setDashboards(requestContext, (Client)client, kbnVersion, this.cdmProjectPrefix);
                    this.aclManager.syncAcl(requestContext);
                }
            }
            this.threadPool.getThreadContext().putTransient("x-openshift-request-context", (Object)requestContext);
        }
        catch (ElasticsearchSecurityException ese) {
            LOGGER.info("Could not authenticate user");
            channel.sendResponse((RestResponse)new BytesRestResponse(RestStatus.UNAUTHORIZED, ""));
            request = null;
        }
        catch (Exception e) {
            LOGGER.error("Error handling request", (Throwable)e);
        }
        return request;
    }

    private void logRequest(RestRequest request) {
        if (LOGGER.isDebugEnabled()) {
            try {
                LOGGER.debug("Handling Request... {}", (Object)request.uri());
                String user = this.utils.getUser(request);
                String token = this.utils.getBearerToken(request);
                LOGGER.debug("Evaluating request for user '{}' with a {} token", (Object)user, (Object)(StringUtils.isNotEmpty((String)token) ? "non-empty" : "empty"));
                if (LOGGER.isTraceEnabled()) {
                    ArrayList<String> headers = new ArrayList<String>();
                    for (Map.Entry entry : request.getHeaders().entrySet()) {
                        if ("Authorization".equals(entry.getKey())) {
                            headers.add((String)entry.getKey() + "=Bearer <REDACTED>");
                            continue;
                        }
                        headers.add((String)entry.getKey() + "=" + entry.getValue());
                    }
                    LOGGER.trace("Request headers: {}", headers);
                }
            }
            catch (Exception e) {
                LOGGER.debug("unable to log request: " + e.getMessage());
            }
        }
    }

    private String getKibanaVersion(RestRequest request) {
        String kbnVersion = StringUtils.defaultIfEmpty((String)request.header(this.kbnVersionHeader), (String)"");
        if (StringUtils.isEmpty((String)kbnVersion)) {
            return this.kibanaVersion;
        }
        return kbnVersion;
    }
}

