/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.apache.commons.lang.StringUtils;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.get.GetAliasesResponse;
import org.elasticsearch.action.admin.indices.create.CreateIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.create.CreateIndexResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.admin.indices.get.GetIndexRequestBuilder;
import org.elasticsearch.action.admin.indices.get.GetIndexResponse;
import org.elasticsearch.action.admin.indices.refresh.RefreshRequestBuilder;
import org.elasticsearch.action.admin.indices.refresh.RefreshResponse;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsRequestBuilder;
import org.elasticsearch.action.admin.indices.settings.put.UpdateSettingsResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetRequestBuilder;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.index.IndexRequestBuilder;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.update.UpdateRequestBuilder;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContentType;

public class PluginClient {
    private static Logger LOGGER = Loggers.getLogger(PluginClient.class);
    private final Client client;
    private final ThreadContext threadContext;

    public PluginClient(Client client, ThreadContext threadContext) {
        this.client = client;
        this.threadContext = threadContext;
    }

    public Client getClient() {
        return this.client;
    }

    public void deleteDocument(final String index, final String type, final String id) {
        this.execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                LOGGER.debug("Deleted document: '{}/{}/{}'", (Object)index, (Object)type, (Object)id);
                PluginClient.this.addCommonHeaders();
                DeleteResponse response = (DeleteResponse)PluginClient.this.client.prepareDelete(index, type, id).get();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Document deleted: '{}'", (Object)response.status());
                }
                return null;
            }
        });
    }

    public void updateDocument(final String index, final String type, final String id, final String source) {
        this.execute(new Callable<Object>(){

            @Override
            public Object call() throws Exception {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Updating Document: '{}/{}/{}' source: '{}'", (Object)index, (Object)type, (Object)id, (Object)source);
                }
                PluginClient.this.addCommonHeaders();
                UpdateResponse response = (UpdateResponse)PluginClient.this.client.prepareUpdate(index, type, id).setDoc(source, XContentType.JSON).setDocAsUpsert(true).get();
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Document Updated: '{}'", (Object)response.status());
                }
                return null;
            }
        });
    }

    public SearchResponse search(String index, String type) {
        return this.search(new String[]{index}, new String[]{type});
    }

    public SearchResponse search(final String[] indicies, final String[] types) {
        return this.execute(new Callable<SearchResponse>(){

            @Override
            public SearchResponse call() throws Exception {
                PluginClient.this.addCommonHeaders();
                return (SearchResponse)PluginClient.this.client.prepareSearch(indicies).setTypes(types).get();
            }
        });
    }

    public GetIndexResponse getIndex(final String ... indicies) {
        return this.execute(new Callable<GetIndexResponse>(){

            @Override
            public GetIndexResponse call() throws Exception {
                PluginClient.this.addCommonHeaders();
                return (GetIndexResponse)((GetIndexRequestBuilder)PluginClient.this.client.admin().indices().prepareGetIndex().addIndices(indicies)).get();
            }
        });
    }

    public GetResponse getDocument(final String index, final String type, final String id) {
        return this.execute(new Callable<GetResponse>(){

            @Override
            public GetResponse call() throws Exception {
                PluginClient.this.addCommonHeaders();
                return (GetResponse)PluginClient.this.client.prepareGet(index, type, id).get();
            }
        });
    }

    public UpdateResponse update(String index, String type, String id, String source) {
        LOGGER.debug("UPDATE: '{}/{}/{}' source: '{}'", (Object)index, (Object)type, (Object)id, (Object)source);
        UpdateRequestBuilder builder = this.client.prepareUpdate(index, type, id).setDoc(source, XContentType.JSON).setDocAsUpsert(true);
        this.addCommonHeaders();
        UpdateResponse response = (UpdateResponse)builder.get();
        LOGGER.debug("Created with update? '{}'", (Object)response.status());
        return response;
    }

    public IndexResponse createDocument(final String index, final String type, final String id, final String source) {
        return this.execute(new Callable<IndexResponse>(){

            @Override
            public IndexResponse call() throws Exception {
                LOGGER.trace("create document: '{}/{}/{}' source: '{}'", (Object)index, (Object)type, (Object)id, (Object)source);
                IndexRequestBuilder builder = PluginClient.this.client.prepareIndex(index, type, id).setSource(source, XContentType.JSON);
                PluginClient.this.addCommonHeaders();
                IndexResponse response = (IndexResponse)builder.get();
                return response;
            }
        });
    }

    public GetIndexResponse getIndices(String ... indices) throws InterruptedException, ExecutionException {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Getting indices '{}'", (Object)StringUtils.join((Object[])indices, (String)", "));
        }
        GetIndexRequestBuilder builder = (GetIndexRequestBuilder)this.client.admin().indices().prepareGetIndex().setIndices(indices);
        this.addCommonHeaders();
        return (GetIndexResponse)builder.get();
    }

    public CreateIndexResponse copyIndex(String index, String target, Settings settings, String ... types) throws InterruptedException, ExecutionException, IOException {
        LOGGER.trace("Copying {} index to {} for types {}", (Object)index, (Object)target, (Object)types);
        GetIndexResponse response = this.getIndices(index);
        CreateIndexRequestBuilder builder = this.client.admin().indices().prepareCreate(target);
        if (settings != null) {
            builder.setSettings(settings);
        }
        for (String type : types) {
            builder.addMapping(type, ((MappingMetaData)((ImmutableOpenMap)response.mappings().get((Object)index)).get((Object)type)).getSourceAsMap());
        }
        this.addCommonHeaders();
        return (CreateIndexResponse)builder.get();
    }

    public UpdateSettingsResponse updateSettings(String index, Settings settings) {
        UpdateSettingsRequestBuilder builder = this.client.admin().indices().prepareUpdateSettings(new String[]{index}).setSettings(settings);
        this.addCommonHeaders();
        return (UpdateSettingsResponse)builder.get();
    }

    public RefreshResponse refreshIndices(String ... indices) {
        RefreshRequestBuilder builder = this.client.admin().indices().prepareRefresh(indices);
        this.addCommonHeaders();
        RefreshResponse response = (RefreshResponse)builder.get();
        LOGGER.debug("Refreshed '{}' successfully on {} of {} shards", (Object)indices, (Object)response.getSuccessfulShards(), (Object)response.getTotalShards());
        return response;
    }

    public boolean indexExists(final String index) {
        return this.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.trace("Checking for existance of index '{}'", (Object)index);
                IndicesExistsRequestBuilder builder = PluginClient.this.client.admin().indices().prepareExists(new String[]{index});
                PluginClient.this.addCommonHeaders();
                IndicesExistsResponse response = (IndicesExistsResponse)builder.get();
                boolean exists = response.isExists();
                LOGGER.trace("Index '{}' exists? {}", (Object)index, (Object)exists);
                return exists;
            }
        });
    }

    public boolean documentExists(final String index, final String type, final String id) {
        return this.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                LOGGER.trace("Checking for existence of document: '{}/{}/{}'", (Object)index, (Object)type, (Object)id);
                GetRequestBuilder builder = ((GetRequestBuilder)PluginClient.this.client.prepareGet().setIndex(index)).setType(type).setId(id);
                PluginClient.this.addCommonHeaders();
                GetResponse response = (GetResponse)builder.get();
                boolean exists = response.isExists();
                LOGGER.trace("Document '{}/{}/{}' exists? {}", (Object)index, (Object)type, (Object)id, (Object)exists);
                return exists;
            }
        });
    }

    public Set<String> getIndicesForAlias(final String alias) {
        return this.execute(new Callable<Set<String>>(){

            @Override
            public Set<String> call() throws Exception {
                LOGGER.trace("Retrieving indices for alias '{}'", (Object)alias);
                GetAliasesRequestBuilder builder = PluginClient.this.client.admin().indices().prepareGetAliases(new String[]{alias});
                PluginClient.this.addCommonHeaders();
                GetAliasesResponse response = (GetAliasesResponse)builder.get();
                Iterator keysIt = response.getAliases().keysIt();
                HashSet<String> indices = new HashSet<String>();
                while (keysIt.hasNext()) {
                    indices.add((String)keysIt.next());
                }
                LOGGER.trace("Indices for alias '{}': {}", (Object)alias, indices);
                return indices;
            }
        });
    }

    public boolean alias(final Map<String, String> aliases) {
        return this.execute(new Callable<Boolean>(){

            @Override
            public Boolean call() throws Exception {
                boolean acknowledged = false;
                if (aliases.isEmpty()) {
                    LOGGER.trace("The alias map is empty.  Nothing to do");
                    return acknowledged;
                }
                IndicesAliasesRequestBuilder builder = PluginClient.this.client.admin().indices().prepareAliases();
                PluginClient.this.addCommonHeaders();
                for (Map.Entry entry : aliases.entrySet()) {
                    LOGGER.debug("Creating alias for {} as {}", entry.getKey(), entry.getValue());
                    builder.addAlias((String)entry.getKey(), (String)entry.getValue());
                }
                IndicesAliasesResponse response = (IndicesAliasesResponse)builder.get();
                acknowledged = response.isAcknowledged();
                LOGGER.debug("Aliases request acknowledged? {}", (Object)acknowledged);
                return acknowledged;
            }
        });
    }

    public void addCommonHeaders() {
        if (StringUtils.isBlank((String)((String)this.threadContext.getTransient("_sg_channel_type")))) {
            this.threadContext.putTransient("_sg_channel_type", (Object)"direct");
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T execute(Callable<T> callable) {
        try (ThreadContext.StoredContext context = this.threadContext.stashContext();){
            this.threadContext.putTransient("_sg_channel_type", (Object)"direct");
            T t = callable.call();
            return t;
        }
        catch (Exception e) {
            throw new ElasticsearchException((Throwable)e);
        }
    }
}

