/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.acl.ACLDocumentManager;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.cluster.LocalNodeMasterListener;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.EsExecutors;
import org.elasticsearch.common.util.concurrent.FutureUtils;

public class OpenShiftElasticSearchService
extends AbstractLifecycleComponent
implements ConfigurationSettings,
LocalNodeMasterListener {
    private static final Logger LOGGER = Loggers.getLogger(OpenShiftElasticSearchService.class);
    private final PluginSettings settings;
    private final ACLDocumentManager aclManager;
    private ScheduledThreadPoolExecutor scheduler;
    private ScheduledFuture scheduledFuture;

    public OpenShiftElasticSearchService(ACLDocumentManager aclManager, PluginSettings pluginSettings) {
        super(pluginSettings.getSettings());
        this.settings = pluginSettings;
        this.aclManager = aclManager;
    }

    protected void doStart() throws ElasticsearchException {
        LOGGER.debug("Started");
    }

    public void onMaster() {
        boolean dynamicEnabled = this.settings.isEnabled();
        LOGGER.debug("Starting with Dynamic ACL feature enabled: {}", (Object)dynamicEnabled);
        if (dynamicEnabled) {
            LOGGER.info("Starting the ACL expiration thread...");
            this.scheduler = (ScheduledThreadPoolExecutor)Executors.newScheduledThreadPool(1, EsExecutors.daemonThreadFactory((Settings)this.settings.getSettings(), (String)"openshift_elasticsearch_service"));
            this.scheduler.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
            this.scheduler.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
            Runnable expire = new Runnable(){

                @Override
                public void run() {
                    OpenShiftElasticSearchService.this.aclManager.expire();
                }
            };
            this.scheduledFuture = this.scheduler.scheduleWithFixedDelay(expire, 60000L, this.settings.getACLExpiresInMillis(), TimeUnit.MILLISECONDS);
        }
    }

    public void offMaster() {
        LOGGER.info("Stopping the ACL expiration thread...");
        FutureUtils.cancel((Future)this.scheduledFuture);
        if (this.scheduler != null) {
            this.scheduler.shutdown();
        }
    }

    public String executorName() {
        return "generic";
    }

    protected void doStop() throws ElasticsearchException {
        this.offMaster();
        LOGGER.debug("Stopped");
    }

    protected void doClose() throws ElasticsearchException {
        this.offMaster();
        LOGGER.debug("Closed");
    }
}

