/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.OpenshiftRequestContextFactory;
import io.fabric8.elasticsearch.plugin.PluginSettings;
import io.fabric8.elasticsearch.plugin.kibana.GetResultBuilder;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Iterator;
import java.util.Map;
import org.apache.logging.log4j.Logger;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.action.admin.indices.mapping.get.GetFieldMappingsResponse;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.action.get.MultiGetItemResponse;
import org.elasticsearch.action.get.MultiGetResponse;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.search.SearchResponse;
import org.elasticsearch.action.support.ActionFilter;
import org.elasticsearch.action.support.ActionFilterChain;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.io.stream.ByteBufferStreamInput;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.io.stream.StreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentFactory;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.common.xcontent.json.JsonXContent;
import org.elasticsearch.index.get.GetResult;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.rest.RestStatus;
import org.elasticsearch.search.SearchHit;
import org.elasticsearch.tasks.Task;

public class KibanaUserReindexAction
implements ActionFilter,
ConfigurationSettings {
    private static final Logger LOG = Loggers.getLogger(KibanaUserReindexAction.class);
    private final String defaultKibanaIndex;
    private final ThreadContext threadContext;

    public KibanaUserReindexAction(PluginSettings settings, Client client, ThreadContext threadContext) {
        this.defaultKibanaIndex = settings.getDefaultKibanaIndex();
        this.threadContext = threadContext;
    }

    public int order() {
        return Integer.MAX_VALUE;
    }

    public void apply(Task task, String action, ActionRequest request, final ActionListener listener, ActionFilterChain chain) {
        LOG.debug("Response with Action '{}'", (Object)action);
        chain.proceed(task, action, request, (ActionListener)new ActionListener<ActionResponse>(){

            public void onResponse(ActionResponse response) {
                OpenshiftRequestContextFactory.OpenshiftRequestContext context = (OpenshiftRequestContextFactory.OpenshiftRequestContext)KibanaUserReindexAction.this.threadContext.getTransient("x-openshift-request-context");
                if (KibanaUserReindexAction.this.containsKibanaUserIndex(response)) {
                    if (response instanceof IndexResponse) {
                        IndexResponse ir = (IndexResponse)response;
                        String index = KibanaUserReindexAction.this.getIndex((ActionResponse)ir);
                        ShardId shardId = ir.getShardId();
                        IndexResponse.Builder builder = new IndexResponse.Builder();
                        builder.setShardId(new ShardId(index, shardId.getIndex().getUUID(), shardId.id()));
                        builder.setType(ir.getType());
                        builder.setId(ir.getId());
                        builder.setVersion(Long.valueOf(ir.getVersion()));
                        builder.setResult(ir.getResult());
                        builder.setShardInfo(ir.getShardInfo());
                        response = builder.build();
                    } else if (response instanceof GetResponse) {
                        response = new GetResponse(KibanaUserReindexAction.this.buildNewResult((GetResponse)response));
                    } else if (response instanceof DeleteResponse) {
                        DeleteResponse dr = (DeleteResponse)response;
                        String index = KibanaUserReindexAction.this.getIndex((ActionResponse)dr);
                        ShardId shardId = dr.getShardId();
                        ReplicationResponse.ShardInfo shardInfo = dr.getShardInfo();
                        ShardId replacedShardId = new ShardId(index, shardId.getIndex().getUUID(), shardId.id());
                        response = new DeleteResponse(replacedShardId, dr.getType(), dr.getId(), dr.getVersion(), RestStatus.NOT_FOUND != dr.status());
                        ((DeleteResponse)response).setShardInfo(shardInfo);
                    } else if (response instanceof MultiGetResponse) {
                        MultiGetResponse mgr = (MultiGetResponse)response;
                        MultiGetItemResponse[] responses = new MultiGetItemResponse[mgr.getResponses().length];
                        int index = 0;
                        for (MultiGetItemResponse item : mgr.getResponses()) {
                            GetResponse itemResponse = item.getResponse();
                            MultiGetResponse.Failure itemFailure = item.getFailure();
                            GetResponse getResponse = itemResponse != null ? new GetResponse(KibanaUserReindexAction.this.buildNewResult(itemResponse)) : null;
                            MultiGetResponse.Failure failure = itemFailure != null ? KibanaUserReindexAction.this.buildNewFailure(itemFailure) : null;
                            responses[index] = new MultiGetItemResponse(getResponse, failure);
                            ++index;
                        }
                        response = new MultiGetResponse(responses);
                    } else if (response instanceof GetFieldMappingsResponse) {
                        GetFieldMappingsResponse gfmResponse = (GetFieldMappingsResponse)response;
                        Map mappings = gfmResponse.mappings();
                        String index = "";
                        for (String key : mappings.keySet()) {
                            index = key;
                            if (!KibanaUserReindexAction.this.isKibanaUserIndex(index)) continue;
                            index = KibanaUserReindexAction.this.defaultKibanaIndex;
                        }
                        BytesStreamOutput bso = new BytesStreamOutput();
                        try {
                            MappingResponseRemapper remapper = new MappingResponseRemapper();
                            remapper.updateMappingResponse((StreamOutput)bso, index, mappings);
                            ByteBuffer buffer = ByteBuffer.wrap(bso.bytes().toBytesRef().bytes);
                            ByteBufferStreamInput input = new ByteBufferStreamInput(buffer);
                            response.readFrom((StreamInput)input);
                        }
                        catch (IOException e) {
                            LOG.error("Error while rewriting GetFieldMappingsResponse", (Throwable)e);
                        }
                    } else if (response instanceof SearchResponse && context != null) {
                        String json = Strings.toString((ToXContent)((SearchResponse)response));
                        json = json.replaceAll("_index\".?:.?\"" + context.getKibanaIndex() + "\"", "_index\":\"" + KibanaUserReindexAction.this.defaultKibanaIndex + "\"");
                        LOG.debug("Modified SearchResponse to {}", (Object)json);
                        try (XContentParser parser = XContentFactory.xContent((XContentType)XContentType.JSON).createParser(NamedXContentRegistry.EMPTY, json);){
                            response = SearchResponse.fromXContent((XContentParser)parser);
                        }
                        catch (IOException e) {
                            LOG.error("Error trying to modify kibana index response", (Throwable)e);
                        }
                    }
                }
                listener.onResponse((Object)response);
            }

            public void onFailure(Exception e) {
                listener.onFailure(e);
            }
        });
    }

    private GetResult buildNewResult(GetResponse response) {
        String index = this.getIndex((ActionResponse)response);
        String replacedIndex = response.getIndex();
        return new GetResultBuilder().index(index).replacedIndex(replacedIndex).response(response).build();
    }

    private MultiGetResponse.Failure buildNewFailure(MultiGetResponse.Failure failure) {
        String index = failure.getIndex();
        String message = failure.getMessage();
        if (this.isKibanaUserIndex(index)) {
            message = message.replace(index, this.defaultKibanaIndex);
            index = this.defaultKibanaIndex;
        }
        Exception t = new Exception(message, failure.getFailure().getCause());
        return new MultiGetResponse.Failure(index, failure.getType(), failure.getId(), t);
    }

    private boolean isKibanaUserIndex(String index) {
        return index.startsWith(this.defaultKibanaIndex) && !index.equalsIgnoreCase(this.defaultKibanaIndex);
    }

    private String getIndex(ActionResponse response) {
        String index = "";
        if (response instanceof IndexResponse) {
            index = ((IndexResponse)response).getIndex();
        } else if (response instanceof GetResponse) {
            index = ((GetResponse)response).getIndex();
        } else if (response instanceof DeleteResponse) {
            index = ((DeleteResponse)response).getIndex();
        }
        if (this.isKibanaUserIndex(index)) {
            index = this.defaultKibanaIndex;
        }
        return index;
    }

    private boolean containsKibanaUserIndex(ActionResponse response) {
        String index = "";
        if (response instanceof MultiGetResponse) {
            for (MultiGetItemResponse item : ((MultiGetResponse)response).getResponses()) {
                GetResponse itemResponse = item.getResponse();
                MultiGetResponse.Failure itemFailure = item.getFailure();
                if (!(itemResponse == null ? this.isKibanaUserIndex(itemFailure.getIndex()) : this.isKibanaUserIndex(itemResponse.getIndex()))) continue;
                return true;
            }
            return false;
        }
        if (response instanceof SearchResponse) {
            SearchResponse search = (SearchResponse)response;
            for (SearchHit hit : search.getHits()) {
                if (!this.isKibanaUserIndex(hit.getIndex())) continue;
                return true;
            }
        }
        if (response instanceof IndexResponse) {
            index = ((IndexResponse)response).getIndex();
        } else if (response instanceof GetResponse) {
            index = ((GetResponse)response).getIndex();
        } else if (response instanceof DeleteResponse) {
            index = ((DeleteResponse)response).getIndex();
        } else if (response instanceof GetFieldMappingsResponse) {
            Map mappings = ((GetFieldMappingsResponse)response).mappings();
            Iterator iterator = mappings.keySet().iterator();
            while (iterator.hasNext()) {
                String key;
                index = key = (String)iterator.next();
            }
        }
        return this.isKibanaUserIndex(index);
    }

    private static class MappingResponseRemapper
    extends ActionResponse
    implements ToXContent {
        private MappingResponseRemapper() {
        }

        public void updateMappingResponse(StreamOutput out, String index, Map<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>> mappings) throws IOException {
            super.writeTo(out);
            out.writeVInt(mappings.size());
            for (Map.Entry<String, Map<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>>> indexEntry : mappings.entrySet()) {
                out.writeString(index);
                out.writeVInt(indexEntry.getValue().size());
                for (Map.Entry<String, Map<String, GetFieldMappingsResponse.FieldMappingMetaData>> typeEntry : indexEntry.getValue().entrySet()) {
                    out.writeString(typeEntry.getKey());
                    out.writeVInt(typeEntry.getValue().size());
                    for (Map.Entry<String, GetFieldMappingsResponse.FieldMappingMetaData> fieldEntry : typeEntry.getValue().entrySet()) {
                        out.writeString(fieldEntry.getKey());
                        GetFieldMappingsResponse.FieldMappingMetaData fieldMapping = fieldEntry.getValue();
                        out.writeString(fieldMapping.fullName());
                        Map map = fieldMapping.sourceAsMap();
                        XContentBuilder builder = XContentBuilder.builder((XContent)JsonXContent.jsonXContent);
                        builder.map(map).close();
                        out.writeBytesReference(builder.bytes());
                    }
                }
            }
        }

        public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
            return null;
        }
    }
}

