/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.rest;

import io.fabric8.elasticsearch.plugin.ConfigurationSettings;
import io.fabric8.elasticsearch.plugin.KibanaUserReindexFilter;
import io.fabric8.elasticsearch.util.RequestUtils;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.rest.BaseRestHandler;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestFilter;
import org.elasticsearch.rest.RestRequest;

public class KibanaUserRestHandler
extends BaseRestHandler
implements ConfigurationSettings {
    private final ESLogger logger = Loggers.getLogger(KibanaUserRestHandler.class);

    @Inject
    public KibanaUserRestHandler(Settings settings, RestController controller, Client client, RequestUtils utils) {
        super(settings, controller, client);
        boolean reindexEnabled = settings.getAsBoolean("openshift.kibana.rewrite.enabled", Boolean.valueOf(true));
        this.logger.debug("Starting with Kibana reindexing feature enabled: {}", new Object[]{reindexEnabled});
        if (reindexEnabled) {
            controller.registerFilter((RestFilter)new KibanaUserReindexFilter(settings, this.logger, utils));
        }
    }

    public void handleRequest(RestRequest request, RestChannel channel, Client client) throws Exception {
    }
}

