/*
 * Decompiled with CFR 0.152.
 */
package io.fabric8.elasticsearch.plugin;

import java.util.Map;
import org.elasticsearch.action.ActionRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequestBuilder;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsRequestBuilder;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.logging.ESLogger;
import org.elasticsearch.common.logging.Loggers;

public class PluginClient {
    private static ESLogger LOGGER = Loggers.getLogger(PluginClient.class);
    private final Client client;

    @Inject
    public PluginClient(Client client) {
        this.client = client;
    }

    public boolean indexExists(String index) {
        LOGGER.trace("Checking for existance of index '{}'", new Object[]{index});
        IndicesExistsRequestBuilder builder = this.client.admin().indices().prepareExists(new String[]{index});
        this.addCommonHeaders((ActionRequestBuilder)builder);
        IndicesExistsResponse response = (IndicesExistsResponse)builder.get();
        boolean exists = response.isExists();
        LOGGER.trace("Index '{}' exists? {}", new Object[]{index, exists});
        return exists;
    }

    public boolean alias(Map<String, String> aliases) {
        boolean acknowledged = false;
        if (aliases.isEmpty()) {
            return acknowledged;
        }
        IndicesAliasesRequestBuilder builder = this.client.admin().indices().prepareAliases();
        this.addCommonHeaders((ActionRequestBuilder)builder);
        for (Map.Entry<String, String> entry : aliases.entrySet()) {
            LOGGER.debug("Creating alias for {} as {}", new Object[]{entry.getKey(), entry.getValue()});
            builder.addAlias(entry.getKey(), entry.getValue());
        }
        IndicesAliasesResponse response = (IndicesAliasesResponse)builder.get();
        acknowledged = response.isAcknowledged();
        LOGGER.debug("Aliases request acknowledged? {}", new Object[]{acknowledged});
        return acknowledged;
    }

    private void addCommonHeaders(ActionRequestBuilder builder) {
        builder.putHeader("_sg_conf_request", (Object)"true");
    }
}

