/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.user;

import com.google.common.collect.Lists;
import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

public class User
implements Serializable {
    public static final User ANONYMOUS = new User("sg_anonymous", Lists.newArrayList((Object[])new String[]{"sg_anonymous_backendrole"}));
    public static final User SG_INTERNAL = new User("_sg_internal");
    private static final long serialVersionUID = -5500938501822658596L;
    private final String name;
    private final Set<String> roles = new HashSet<String>();

    public User(String name, Collection<String> toAdd) {
        if (name == null || name.isEmpty()) {
            throw new IllegalArgumentException("name must not be null or empty");
        }
        this.name = name;
        if (toAdd != null) {
            this.addRoles(toAdd);
        }
    }

    public User(String name) {
        this(name, null);
    }

    public String getName() {
        return this.name;
    }

    public Set<String> getRoles() {
        return Collections.unmodifiableSet(this.roles);
    }

    public void addRole(String role) {
        this.roles.add(role);
    }

    public void addRoles(Collection<String> toAdd) {
        this.roles.addAll(toAdd);
    }

    public boolean isUserInRole(String role) {
        return this.roles.contains(role);
    }

    public String toString() {
        return "User [name=" + this.name + ", roles=" + this.roles + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        User other = (User)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public void copyRolesFrom(User user) {
        this.addRoles(user.getRoles());
    }
}

