/*
 * Decompiled with CFR 0.152.
 */
package com.floragunn.searchguard.http;

import com.floragunn.searchguard.auditlog.AuditLog;
import com.floragunn.searchguard.ssl.SearchGuardKeyStore;
import com.floragunn.searchguard.ssl.http.netty.SearchGuardSSLNettyHttpServerTransport;
import com.floragunn.searchguard.ssl.transport.PrincipalExtractor;
import com.floragunn.searchguard.support.HeaderHelper;
import java.io.IOException;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.network.NetworkService;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.BigArrays;
import org.elasticsearch.http.netty.NettyHttpRequest;
import org.elasticsearch.rest.BytesRestResponse;
import org.elasticsearch.rest.RestChannel;
import org.elasticsearch.rest.RestRequest;
import org.elasticsearch.rest.RestResponse;
import org.elasticsearch.rest.RestStatus;

public class SearchGuardHttpServerTransport
extends SearchGuardSSLNettyHttpServerTransport {
    private final AuditLog auditLog;

    @Inject
    public SearchGuardHttpServerTransport(Settings settings, NetworkService networkService, BigArrays bigArrays, SearchGuardKeyStore sgks, AuditLog auditLog, PrincipalExtractor principalExtractor) {
        super(settings, networkService, bigArrays, sgks, principalExtractor);
        this.auditLog = auditLog;
    }

    protected void errorThrown(Throwable t, NettyHttpRequest request) {
        this.auditLog.logSSLException((RestRequest)request, t, null);
        super.errorThrown(t, request);
    }

    public void dispatchRequest(RestRequest request, RestChannel channel) {
        try {
            HeaderHelper.checkSGHeader(request);
        }
        catch (Exception e) {
            this.auditLog.logBadHeaders(request);
            try {
                channel.sendResponse((RestResponse)new BytesRestResponse(channel, RestStatus.FORBIDDEN, (Throwable)e));
            }
            catch (IOException iOException) {
                // empty catch block
            }
            return;
        }
        super.dispatchRequest(request, channel);
    }
}

